/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.plugin;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import junit.framework.Test;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.core.plugin.PluginLoader;
import org.apache.flink.test.plugin.OtherTestSpi;
import org.apache.flink.test.plugin.PluginTestBase;
import org.apache.flink.test.plugin.TestSpi;
import org.apache.flink.test.plugin.jar.plugina.TestServiceA;
import org.junit.Assert;

public class PluginLoaderTest
extends PluginTestBase {
    @org.junit.Test
    public void testPluginLoading() throws Exception {
        URL classpathA = this.createPluginJarURLFromString("plugin-a-test-jar.jar");
        String[] parentPatterns = new String[]{TestSpi.class.getName(), OtherTestSpi.class.getName()};
        PluginDescriptor pluginDescriptorA = new PluginDescriptor("A", new URL[]{classpathA}, parentPatterns);
        URLClassLoader pluginClassLoaderA = PluginLoader.createPluginClassLoader((PluginDescriptor)pluginDescriptorA, (ClassLoader)PARENT_CLASS_LOADER, (String[])new String[0]);
        Assert.assertNotEquals((Object)PARENT_CLASS_LOADER, (Object)pluginClassLoaderA);
        PluginLoader pluginLoaderA = new PluginLoader("test-plugin", pluginClassLoaderA);
        Iterator testSpiIteratorA = pluginLoaderA.load(TestSpi.class);
        Assert.assertTrue((boolean)testSpiIteratorA.hasNext());
        TestSpi testSpiA = (TestSpi)testSpiIteratorA.next();
        Assert.assertFalse((boolean)testSpiIteratorA.hasNext());
        Assert.assertNotNull((Object)testSpiA.testMethod());
        Assert.assertEquals((Object)TestServiceA.class.getCanonicalName(), (Object)testSpiA.getClass().getCanonicalName());
        Assert.assertEquals((Object)pluginClassLoaderA, (Object)testSpiA.getClassLoader());
        Assert.assertEquals((Object)pluginClassLoaderA, (Object)testSpiA.getClass().getClassLoader());
        Assert.assertFalse((boolean)(testSpiA instanceof TestServiceA));
        PluginLoader secondPluginLoaderA = PluginLoader.create((PluginDescriptor)pluginDescriptorA, (ClassLoader)PARENT_CLASS_LOADER, (String[])new String[0]);
        TestSpi secondTestSpiA = (TestSpi)secondPluginLoaderA.load(TestSpi.class).next();
        Assert.assertNotNull((Object)secondTestSpiA.testMethod());
        Assert.assertEquals((Object)testSpiA.getClass().getCanonicalName(), (Object)secondTestSpiA.getClass().getCanonicalName());
        Assert.assertNotEquals(testSpiA.getClass(), secondTestSpiA.getClass());
    }

    @org.junit.Test
    public void testClose() throws MalformedURLException {
        URL classpathA = this.createPluginJarURLFromString("plugin-a-test-jar.jar");
        String[] parentPatterns = new String[]{TestSpi.class.getName()};
        PluginDescriptor pluginDescriptorA = new PluginDescriptor("A", new URL[]{classpathA}, parentPatterns);
        URLClassLoader pluginClassLoaderA = PluginLoader.createPluginClassLoader((PluginDescriptor)pluginDescriptorA, (ClassLoader)PARENT_CLASS_LOADER, (String[])new String[0]);
        PluginLoader pluginLoaderA = new PluginLoader("test-plugin", pluginClassLoaderA);
        pluginLoaderA.close();
        Assert.assertThrows(ClassNotFoundException.class, () -> pluginClassLoaderA.loadClass(Test.class.getName()));
    }
}

