/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.io.BufferedReader;
import java.io.File;
import java.util.Random;
import java.util.UUID;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataSinkITCase
extends MultipleProgramsTestBase {
    private String resultPath;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public DataSinkITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Before
    public void before() throws Exception {
        File folder = this.tempFolder.newFolder();
        File resultFile = new File(folder, UUID.randomUUID().toString());
        this.resultPath = resultFile.toURI().toString();
    }

    @Test
    public void testIntSortingParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Integer> ds = CollectionDataSets.getIntegerDataSet(env);
        ds.writeAsText(this.resultPath).sortLocalOutput("*", Order.DESCENDING).setParallelism(1);
        env.execute();
        String expected = "5\n5\n5\n5\n5\n4\n4\n4\n4\n3\n3\n3\n2\n2\n1\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testStringSortingParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<String> ds = CollectionDataSets.getStringDataSet(env);
        ds.writeAsText(this.resultPath).sortLocalOutput("*", Order.ASCENDING).setParallelism(1);
        env.execute();
        String expected = "Hello\nHello world\nHello world, how are you?\nHi\nI am fine.\nLOL\nLuke Skywalker\nRandom comment\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testTupleSortingSingleAscParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ds.writeAsCsv(this.resultPath).sortLocalOutput(0, Order.ASCENDING).setParallelism(1);
        env.execute();
        String expected = "1,1,Hi\n2,2,Hello\n3,2,Hello world\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testTupleSortingSingleDescParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ds.writeAsCsv(this.resultPath).sortLocalOutput(0, Order.DESCENDING).setParallelism(1);
        env.execute();
        String expected = "21,6,Comment#15\n20,6,Comment#14\n19,6,Comment#13\n18,6,Comment#12\n17,6,Comment#11\n16,6,Comment#10\n15,5,Comment#9\n14,5,Comment#8\n13,5,Comment#7\n12,5,Comment#6\n11,5,Comment#5\n10,4,Comment#4\n9,4,Comment#3\n8,4,Comment#2\n7,4,Comment#1\n6,3,Luke Skywalker\n5,3,I am fine.\n4,3,Hello world, how are you?\n3,2,Hello world\n2,2,Hello\n1,1,Hi\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testTupleSortingDualParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Integer, Long, String>> ds = CollectionDataSets.get3TupleDataSet(env);
        ds.writeAsCsv(this.resultPath).sortLocalOutput(1, Order.DESCENDING).sortLocalOutput(0, Order.ASCENDING).setParallelism(1);
        env.execute();
        String expected = "16,6,Comment#10\n17,6,Comment#11\n18,6,Comment#12\n19,6,Comment#13\n20,6,Comment#14\n21,6,Comment#15\n11,5,Comment#5\n12,5,Comment#6\n13,5,Comment#7\n14,5,Comment#8\n15,5,Comment#9\n7,4,Comment#1\n8,4,Comment#2\n9,4,Comment#3\n10,4,Comment#4\n4,3,Hello world, how are you?\n5,3,I am fine.\n6,3,Luke Skywalker\n2,2,Hello\n3,2,Hello world\n1,1,Hi\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testTupleSortingNestedParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Tuple2<Integer, Integer>, String, Integer>> ds = CollectionDataSets.getGroupSortedNestedTupleDataSet2(env);
        ds.writeAsText(this.resultPath).sortLocalOutput("f0.f1", Order.ASCENDING).sortLocalOutput("f1", Order.DESCENDING).setParallelism(1);
        env.execute();
        String expected = "((2,1),a,3)\n((2,2),b,4)\n((1,2),a,1)\n((3,3),c,5)\n((1,3),a,2)\n((3,6),c,6)\n((4,9),c,7)\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testTupleSortingNestedParallelism1_2() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Tuple3<Tuple2<Integer, Integer>, String, Integer>> ds = CollectionDataSets.getGroupSortedNestedTupleDataSet2(env);
        ds.writeAsText(this.resultPath).sortLocalOutput(1, Order.ASCENDING).sortLocalOutput(2, Order.DESCENDING).setParallelism(1);
        env.execute();
        String expected = "((2,1),a,3)\n((1,3),a,2)\n((1,2),a,1)\n((2,2),b,4)\n((4,9),c,7)\n((3,6),c,6)\n((3,3),c,5)\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testPojoSortingSingleParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets.getMixedPojoDataSet(env);
        ds.writeAsText(this.resultPath).sortLocalOutput("number", Order.ASCENDING).setParallelism(1);
        env.execute();
        String expected = "1 First (10,100,1000,One) 10100\n2 First_ (10,105,1000,One) 10200\n3 First (11,102,3000,One) 10200\n4 First_ (11,106,1000,One) 10300\n5 First (11,102,2000,One) 10100\n6 Second_ (20,200,2000,Two) 10100\n7 Third (31,301,2000,Three) 10200\n8 Third_ (30,300,1000,Three) 10100\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testPojoSortingDualParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets.getMixedPojoDataSet(env);
        ds.writeAsText(this.resultPath).sortLocalOutput("str", Order.ASCENDING).sortLocalOutput("number", Order.DESCENDING).setParallelism(1);
        env.execute();
        String expected = "5 First (11,102,2000,One) 10100\n3 First (11,102,3000,One) 10200\n1 First (10,100,1000,One) 10100\n4 First_ (11,106,1000,One) 10300\n2 First_ (10,105,1000,One) 10200\n6 Second_ (20,200,2000,Two) 10100\n7 Third (31,301,2000,Three) 10200\n8 Third_ (30,300,1000,Three) 10100\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testPojoSortingNestedParallelism1() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<CollectionDataSets.POJO> ds = CollectionDataSets.getMixedPojoDataSet(env);
        ds.writeAsText(this.resultPath).sortLocalOutput("nestedTupleWithCustom.f0", Order.ASCENDING).sortLocalOutput("nestedTupleWithCustom.f1.myInt", Order.DESCENDING).sortLocalOutput("nestedPojo.longNumber", Order.ASCENDING).setParallelism(1);
        env.execute();
        String expected = "2 First_ (10,105,1000,One) 10200\n1 First (10,100,1000,One) 10100\n4 First_ (11,106,1000,One) 10300\n5 First (11,102,2000,One) 10100\n3 First (11,102,3000,One) 10200\n6 Second_ (20,200,2000,Two) 10100\n8 Third_ (30,300,1000,Three) 10100\n7 Third (31,301,2000,Three) 10200\n";
        DataSinkITCase.compareResultsByLinesInMemoryWithStrictOrder((String)expected, (String)this.resultPath);
    }

    @Test
    public void testSortingParallelism4() throws Exception {
        BufferedReader[] resReaders;
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource ds = env.generateSequence(0L, 1000L);
        ds.map((MapFunction)new MapFunction<Long, Long>(){
            Random rand = new Random(1234L);

            public Long map(Long value) throws Exception {
                return this.rand.nextLong();
            }
        }).writeAsText(this.resultPath).sortLocalOutput("*", Order.ASCENDING).setParallelism(4);
        env.execute();
        for (BufferedReader br : resReaders = DataSinkITCase.getResultReader((String)this.resultPath)) {
            long cmp = Long.MIN_VALUE;
            while (br.ready()) {
                long cur = Long.parseLong(br.readLine());
                Assert.assertTrue((String)"Invalid order of sorted output", (cmp <= cur ? 1 : 0) != 0);
                cmp = cur;
            }
            br.close();
        }
    }
}

