/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.junit5;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class JUnitJupiterTest {
    @Test
    @DisplayName(value="Assumption and Assertion Test")
    public void assumptionAssertionTest() {
        Assumptions.assumeTrue((boolean)true, (String)"This case is absolutely true");
        Assertions.assertTrue((boolean)true, (String)"This case is absolutely true");
    }

    @ParameterizedTest
    @DisplayName(value="Parameterized Test")
    @ValueSource(strings={"racecar", "radar", "able was I ere I saw elba"})
    public void parameterizedTest(String word) {
        Assertions.assertTrue((boolean)this.isPalindrome(word), (String)"The string in parameter should be palindrome");
    }

    @TestFactory
    @DisplayName(value="Dynamic Test")
    Collection<DynamicTest> dynamicTest() {
        String word = "madam";
        String anotherWord = "flink";
        return Arrays.asList(DynamicTest.dynamicTest((String)"1st dynamic test", () -> Assertions.assertTrue((boolean)this.isPalindrome(word))), DynamicTest.dynamicTest((String)"2nd dynamic test", () -> Assertions.assertFalse((boolean)this.isPalindrome(anotherWord))));
    }

    private boolean isPalindrome(String word) {
        return StringUtils.reverse((String)word).equals(word);
    }
}

