/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.distributedcache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class DistributedCacheTest
extends AbstractTestBase {
    public static final String DATA = "machen\nzeit\nheerscharen\nkeiner\nmeine\n";

    @Test
    public void testStreamingDistributedCache() throws Exception {
        String textPath = this.createTempFile("count.txt", DATA);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.registerCachedFile(textPath, "cache_test");
        env.readTextFile(textPath).flatMap((FlatMapFunction)new WordChecker());
        env.execute();
    }

    @Test
    public void testBatchDistributedCache() throws Exception {
        String textPath = this.createTempFile("count.txt", DATA);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        env.registerCachedFile(textPath, "cache_test");
        env.readTextFile(textPath).flatMap((FlatMapFunction)new WordChecker()).count();
    }

    private static class WordChecker
    extends RichFlatMapFunction<String, Tuple1<String>> {
        private static final long serialVersionUID = 1L;
        private final List<String> wordList = new ArrayList<String>();

        private WordChecker() {
        }

        public void open(Configuration conf) throws IOException {
            File file = this.getRuntimeContext().getDistributedCache().getFile("cache_test");
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String tempString;
                while ((tempString = reader.readLine()) != null) {
                    this.wordList.add(tempString);
                }
            }
        }

        public void flatMap(String word, Collector<Tuple1<String>> out) throws Exception {
            Assert.assertTrue((String)("Unexpected word in stream! wordFromStream: " + word + ", shouldBeOneOf: " + this.wordList.toString()), (boolean)this.wordList.contains(word));
            out.collect((Object)new Tuple1((Object)word));
        }
    }
}

