/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.checkpointing;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.test.checkpointing.EventTimeWindowCheckpointingITCase;
import org.apache.flink.util.TestLogger;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LocalRecoveryITCase
extends TestLogger {
    @Rule
    public TestName testName = new TestName();
    @Parameterized.Parameter
    public EventTimeWindowCheckpointingITCase.StateBackendEnum backendEnum;

    @Parameterized.Parameters(name="statebackend type ={0}")
    public static Collection<EventTimeWindowCheckpointingITCase.StateBackendEnum> parameter() {
        return Arrays.asList(EventTimeWindowCheckpointingITCase.StateBackendEnum.ROCKSDB_FULL, EventTimeWindowCheckpointingITCase.StateBackendEnum.ROCKSDB_INCREMENTAL_ZK, EventTimeWindowCheckpointingITCase.StateBackendEnum.FILE);
    }

    @Test
    public final void executeTest() throws Exception {
        EventTimeWindowCheckpointingITCase.tempFolder.create();
        EventTimeWindowCheckpointingITCaseInstance windowChkITCase = new EventTimeWindowCheckpointingITCaseInstance(this.backendEnum, true);
        this.executeTest(windowChkITCase);
    }

    private void executeTest(EventTimeWindowCheckpointingITCase delegate) throws Exception {
        delegate.name = this.testName;
        delegate.stateBackendEnum = this.backendEnum;
        try {
            delegate.setupTestCluster();
            try {
                delegate.testTumblingTimeWindow();
                delegate.stopTestCluster();
            }
            catch (Exception e) {
                delegate.stopTestCluster();
                throw new RuntimeException(e);
            }
            delegate.setupTestCluster();
            try {
                delegate.testSlidingTimeWindow();
                delegate.stopTestCluster();
            }
            catch (Exception e) {
                delegate.stopTestCluster();
                throw new RuntimeException(e);
            }
        }
        finally {
            EventTimeWindowCheckpointingITCase.tempFolder.delete();
        }
    }

    @Ignore(value="Prevents this class from being considered a test class by JUnit.")
    private static class EventTimeWindowCheckpointingITCaseInstance
    extends EventTimeWindowCheckpointingITCase {
        private final EventTimeWindowCheckpointingITCase.StateBackendEnum backendEnum;
        private final boolean localRecoveryEnabled;

        public EventTimeWindowCheckpointingITCaseInstance(EventTimeWindowCheckpointingITCase.StateBackendEnum backendEnum, boolean localRecoveryEnabled) {
            super(backendEnum, 2);
            this.backendEnum = backendEnum;
            this.localRecoveryEnabled = localRecoveryEnabled;
        }

        @Override
        protected EventTimeWindowCheckpointingITCase.StateBackendEnum getStateBackend() {
            return this.backendEnum;
        }

        @Override
        protected Configuration createClusterConfig() throws IOException {
            Configuration config = super.createClusterConfig();
            config.setBoolean(CheckpointingOptions.LOCAL_RECOVERY, this.localRecoveryEnabled);
            return config;
        }
    }
}

