/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.operators.lifecycle.TestJobWithDescription;
import org.apache.flink.runtime.operators.lifecycle.event.TestEvent;

public interface TestOperatorLifecycleValidator {
    public void validateOperatorLifecycle(TestJobWithDescription var1, String var2, int var3, List<TestEvent> var4);

    public static void checkOperatorsLifecycle(TestJobWithDescription testJob, TestOperatorLifecycleValidator ... validators) {
        HashMap<Tuple2, List> eventsByOperator = new HashMap<Tuple2, List>();
        for (TestEvent ev : testJob.eventQueue.getAll()) {
            eventsByOperator.computeIfAbsent(Tuple2.of((Object)ev.operatorId, (Object)ev.subtaskIndex), ign -> new ArrayList()).add(ev);
        }
        eventsByOperator.forEach((operatorIdAndIndex, operatorEvents) -> {
            String id = (String)operatorIdAndIndex.f0;
            if (testJob.operatorsWithLifecycleTracking.contains(id)) {
                for (TestOperatorLifecycleValidator validator : validators) {
                    validator.validateOperatorLifecycle(testJob, id, (Integer)operatorIdAndIndex.f1, (List<TestEvent>)operatorEvents);
                }
            }
        });
    }
}

