/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle.validation;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.operators.lifecycle.TestJobWithDescription;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointCompletedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.OperatorFinishedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.TestEvent;
import org.apache.flink.runtime.operators.lifecycle.event.WatermarkReceivedEvent;
import org.apache.flink.runtime.operators.lifecycle.validation.TestOperatorLifecycleValidator;
import org.junit.Assert;

public class FinishingValidator
implements TestOperatorLifecycleValidator {
    @Override
    public void validateOperatorLifecycle(TestJobWithDescription job, String operatorId, int subtaskIndex, List<TestEvent> operatorEvents) {
        boolean opFinished = false;
        HashSet<Long> finalCheckpointCandidates = new HashSet<Long>();
        for (TestEvent ev2 : operatorEvents) {
            if (ev2 instanceof OperatorFinishedEvent) {
                opFinished = true;
                continue;
            }
            if (ev2 instanceof CheckpointStartedEvent) {
                if (!opFinished) continue;
                finalCheckpointCandidates.add(((CheckpointStartedEvent)ev2).checkpointID);
                continue;
            }
            if (ev2 instanceof CheckpointCompletedEvent) {
                if (!finalCheckpointCandidates.contains(((CheckpointCompletedEvent)ev2).checkpointID)) continue;
                return;
            }
            if (!opFinished) continue;
            Assert.fail((String)String.format("Unexpected event after operator %s[%d] finished: %s", operatorId, subtaskIndex, ev2));
        }
        Assert.assertTrue((String)String.format("Operator %s[%d] wasn't finished (events: %s)", operatorId, subtaskIndex, operatorEvents), (boolean)opFinished);
        Assert.fail((String)String.format("Operator %s[%d] was finished but didn't finish the checkpoint after that;checkpoints started after finish: %s (events (excluding watermarks): %s)", operatorId, subtaskIndex, finalCheckpointCandidates, operatorEvents.stream().filter(ev -> !(ev instanceof WatermarkReceivedEvent)).collect(Collectors.toList())));
    }
}

