/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle.graph;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointCompletedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.InputEndedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.OperatorFinishedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.OperatorStartedEvent;
import org.apache.flink.runtime.operators.lifecycle.event.TestEventQueue;
import org.apache.flink.runtime.operators.lifecycle.event.WatermarkReceivedEvent;
import org.apache.flink.runtime.operators.lifecycle.graph.TestDataElement;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;

class OneInputTestStreamOperator
extends AbstractStreamOperator<TestDataElement>
implements OneInputStreamOperator<TestDataElement, TestDataElement>,
BoundedOneInput,
ProcessingTimeCallback {
    private final String operatorID;
    private long lastDataSent;
    private final Map<String, OperatorFinishedEvent.LastVertexDataInfo> lastDataReceived = new HashMap<String, OperatorFinishedEvent.LastVertexDataInfo>();
    private boolean timerRegistered;
    private final TestEventQueue eventQueue;

    OneInputTestStreamOperator(String operatorID, TestEventQueue eventQueue) {
        this.operatorID = operatorID;
        this.eventQueue = eventQueue;
    }

    public void open() throws Exception {
        super.open();
        this.eventQueue.add(new OperatorStartedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber()));
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        this.eventQueue.add(new CheckpointStartedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), context.getCheckpointId()));
        super.snapshotState(context);
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.eventQueue.add(new CheckpointCompletedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), checkpointId));
        super.notifyCheckpointComplete(checkpointId);
    }

    public void finish() throws Exception {
        this.eventQueue.add(new OperatorFinishedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), this.lastDataSent, new OperatorFinishedEvent.LastReceivedVertexDataInfo(this.lastDataReceived)));
        super.finish();
    }

    public void processElement(StreamRecord<TestDataElement> element) throws Exception {
        TestDataElement e = (TestDataElement)element.getValue();
        this.lastDataReceived.computeIfAbsent((String)e.operatorId, (Function<String, OperatorFinishedEvent.LastVertexDataInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processElement$0(java.lang.String ), (Ljava/lang/String;)Lorg/apache/flink/runtime/operators/lifecycle/event/OperatorFinishedEvent$LastVertexDataInfo;)()).bySubtask.put(e.subtaskIndex, e.seq);
        this.output.collect((Object)new StreamRecord((Object)new TestDataElement(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), ++this.lastDataSent)));
        if (!this.timerRegistered) {
            this.registerTimer();
            this.timerRegistered = true;
        }
    }

    public void processWatermark(Watermark mark) throws Exception {
        this.eventQueue.add(new WatermarkReceivedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), mark.getTimestamp(), 1));
        super.processWatermark(mark);
    }

    public void endInput() throws Exception {
        this.eventQueue.add(new InputEndedEvent(this.operatorID, this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber(), 1));
    }

    public void onProcessingTime(long timestamp) {
        this.registerTimer();
    }

    private void registerTimer() {
        this.getProcessingTimeService().registerTimer(this.getProcessingTimeService().getCurrentProcessingTime() + 1L, (ProcessingTimeCallback)this);
    }

    private static /* synthetic */ OperatorFinishedEvent.LastVertexDataInfo lambda$processElement$0(String ign) {
        return new OperatorFinishedEvent.LastVertexDataInfo();
    }
}

