/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.lifecycle;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.operators.lifecycle.TestJobExecutor;
import org.apache.flink.runtime.operators.lifecycle.TestJobWithDescription;
import org.apache.flink.runtime.operators.lifecycle.command.TestCommand;
import org.apache.flink.runtime.operators.lifecycle.command.TestCommandDispatcher;
import org.apache.flink.runtime.operators.lifecycle.event.CheckpointCompletedEvent;
import org.apache.flink.runtime.operators.lifecycle.graph.TestJobBuilders;
import org.apache.flink.runtime.operators.lifecycle.validation.DrainingValidator;
import org.apache.flink.runtime.operators.lifecycle.validation.FinishingValidator;
import org.apache.flink.runtime.operators.lifecycle.validation.TestJobDataFlowValidator;
import org.apache.flink.runtime.operators.lifecycle.validation.TestOperatorLifecycleValidator;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.testutils.junit.SharedObjects;
import org.apache.flink.util.function.ThrowingConsumer;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BoundedSourceITCase
extends AbstractTestBase {
    @Rule
    public final SharedObjects sharedObjects = SharedObjects.create();
    @Parameterized.Parameter
    public TestJobBuilders.TestingGraphBuilder graphBuilder;

    @Parameterized.Parameters(name="{0}")
    public static Object[] parameters() {
        return new Object[]{TestJobBuilders.SIMPLE_GRAPH_BUILDER, TestJobBuilders.COMPLEX_GRAPH_BUILDER};
    }

    @Test
    public void test() throws Exception {
        TestJobWithDescription testJob = this.graphBuilder.build(this.sharedObjects, (ThrowingConsumer<Configuration, Exception>)((ThrowingConsumer)cfg -> cfg.setBoolean(ExecutionCheckpointingOptions.ENABLE_CHECKPOINTS_AFTER_TASKS_FINISH, true)), (ThrowingConsumer<StreamExecutionEnvironment, Exception>)((ThrowingConsumer)env -> env.getCheckpointConfig().setCheckpointStorage(TEMPORARY_FOLDER.newFolder().toURI())));
        TestJobExecutor.execute(testJob, miniClusterResource).waitForEvent(CheckpointCompletedEvent.class).sendBroadcastCommand(TestCommand.FINISH_SOURCES, TestCommandDispatcher.TestCommandScope.ALL_SUBTASKS).waitForTermination().assertFinishedSuccessfully();
        TestOperatorLifecycleValidator.checkOperatorsLifecycle(testJob, new DrainingValidator(), new FinishingValidator());
        TestJobDataFlowValidator.checkDataFlow(testJob);
    }
}

