/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.util;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.api.scala.utils.package$;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001f\t\u0011B)\u0019;b'\u0016$X\u000b^5mg&#6)Y:f\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003\u0015\u00198-\u00197b\u0015\t9\u0001\"A\u0002ba&T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012+5\t!C\u0003\u0002\u0004')\u0011A\u0003C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0017%\tAR*\u001e7uSBdW\r\u0015:pOJ\fWn\u001d+fgR\u0014\u0015m]3\t\u0011a\u0001!\u0011!Q\u0001\ne\tA!\\8eKB\u0011!$\b\b\u0003#mI!\u0001\b\n\u000215+H\u000e^5qY\u0016\u0004&o\\4sC6\u001cH+Z:u\u0005\u0006\u001cX-\u0003\u0002\u001f?\t\tB+Z:u\u000bb,7-\u001e;j_:lu\u000eZ3\u000b\u0005q\u0011\u0002\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\b\u0006\u0002$KA\u0011A\u0005A\u0007\u0002\u0005!)\u0001\u0004\ta\u00013!)q\u0005\u0001C\u0001Q\u0005\u0001B/Z:u5&\u0004x+\u001b;i\u0013:$W\r\u001f\u000b\u0002SA\u0011!\u0006L\u0007\u0002W)\tQ!\u0003\u0002.W\t!QK\\5uQ\r1sF\u0010\t\u0004UA\u0012\u0014BA\u0019,\u0005\u0019!\bN]8xgB\u00111g\u000f\b\u0003ier!!\u000e\u001d\u000e\u0003YR!a\u000e\b\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011B\u0001\u001e,\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0013\u0015C8-\u001a9uS>t'B\u0001\u001e,G\u0005\u0011\u0004F\u0001\u0014A!\t\tE)D\u0001C\u0015\t\u0019E\"A\u0003kk:LG/\u0003\u0002F\u0005\n!A+Z:u\u0011\u00159\u0005\u0001\"\u0001)\u0003M!Xm\u001d;[SB<\u0016\u000e\u001e5V]&\fX/Z%eQ\r1uF\u0010\u0015\u0003\r\u0002CQa\u0013\u0001\u0005\u0002!\n!\u0005^3ti&sG/Z4fe\u0012\u000bG/Y*fi\u000eCWmY6tk6D\u0015m\u001d5D_\u0012,\u0007F\u0001&A\u0011\u0015q\u0005\u0001\"\u0001)\u0003u!Xm\u001d;D_VtG/\u00127f[\u0016tGo\u001d)feB\u000b'\u000f^5uS>t\u0007fA'0}!\u0012Q\n\u0011\u0015\u0005\u0001IC\u0016\f\u0005\u0002T-6\tAK\u0003\u0002V\u0005\u00061!/\u001e8oKJL!a\u0016+\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\n!\f\u0005\u0002\\=6\tAL\u0003\u0002^\u0005\u00069!/\u001e8oKJ\u001c\u0018BA0]\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u0002")
public class DataSetUtilsITCase
extends MultipleProgramsTestBase {
    @Test
    public void testZipWithIndex() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSet numbers = env.generateSequence(0L, expectedSize - 1L);
        Seq result = package$.MODULE$.DataSetUtils(numbers, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long()).zipWithIndex().collect();
        Assert.assertEquals((long)expectedSize, (long)result.size());
        ((TraversableLike)((IterableLike)result.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$)).zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DataSetUtilsITCase.$anonfun$testZipWithIndex$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            DataSetUtilsITCase.$anonfun$testZipWithIndex$3(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testZipWithUniqueId() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSet numbers = env.generateSequence(1L, expectedSize);
        Set result = ((TraversableOnce)package$.MODULE$.DataSetUtils(numbers, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long()).zipWithUniqueId().collect().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._1$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((long)expectedSize, (long)result.size());
    }

    @Test
    public void testIntegerDataSetChecksumHashCode() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> ds = CollectionDataSets$.MODULE$.getIntDataSet(env);
        Utils.ChecksumHashCode checksum = package$.MODULE$.DataSetUtils(ds, (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE), ClassTag$.MODULE$.Int()).checksumHashCode();
        Assert.assertEquals((long)checksum.getCount(), (long)15L);
        Assert.assertEquals((long)checksum.getChecksum(), (long)55L);
    }

    @Test
    public void testCountElementsPerPartition() throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        long expectedSize = 100L;
        DataSet numbers = env.generateSequence(0L, expectedSize - 1L);
        DataSet ds = package$.MODULE$.DataSetUtils(numbers, (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE), ClassTag$.MODULE$.Long()).countElementsPerPartition();
        Assert.assertEquals((long)env.getParallelism(), (long)ds.collect().size());
        Assert.assertEquals((long)expectedSize, (long)((Tuple2)ds.sum(1).collect().head())._2$mcJ$sp());
    }

    public static final /* synthetic */ boolean $anonfun$testZipWithIndex$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testZipWithIndex$3(Tuple2 x$2) {
        int expected;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$2;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                expected = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        long index = tuple2._1$mcJ$sp();
        Assert.assertEquals((long)expected, (long)index);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public DataSetUtilsITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

