/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.windowing.sessionwindows;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.test.windowing.sessionwindows.EventGenerator;
import org.apache.flink.test.windowing.sessionwindows.EventGeneratorFactory;
import org.apache.flink.test.windowing.sessionwindows.LongRandomGenerator;
import org.apache.flink.util.Preconditions;

public class ParallelSessionsEventGenerator<K, E> {
    private final Set<K> sessionKeys;
    private final EventGeneratorFactory<K, E> generatorFactory;
    private final List<EventGenerator<K, E>> subGeneratorLists;
    private final LongRandomGenerator randomGenerator;
    private final long sessionCountLimit;

    public ParallelSessionsEventGenerator(Set<K> keys, EventGeneratorFactory<K, E> generatorFactory, int parallelSessions, long sessionCountLimit, LongRandomGenerator randomGenerator) {
        Preconditions.checkNotNull(keys);
        Preconditions.checkNotNull(generatorFactory);
        Preconditions.checkArgument((parallelSessions > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)randomGenerator);
        this.sessionKeys = keys;
        this.randomGenerator = randomGenerator;
        this.generatorFactory = generatorFactory;
        this.sessionCountLimit = sessionCountLimit;
        this.subGeneratorLists = new ArrayList<EventGenerator<K, E>>(parallelSessions);
        this.initParallelSessionGenerators(parallelSessions);
    }

    public E nextEvent() {
        int choice;
        if (this.subGeneratorLists.isEmpty()) {
            return null;
        }
        long globalWatermark = this.getWatermark();
        for (int i = choice = this.randomGenerator.choseRandomIndex(this.subGeneratorLists); i < choice + this.subGeneratorLists.size(); ++i) {
            int index = i % this.subGeneratorLists.size();
            EventGenerator<K, E> subGenerator = this.subGeneratorLists.get(index);
            if (!subGenerator.canGenerateEventAtWatermark(globalWatermark)) continue;
            E event = subGenerator.generateEvent(globalWatermark);
            if (!subGenerator.hasMoreEvents()) {
                if ((long)this.generatorFactory.getProducedGeneratorsCount() < this.sessionCountLimit) {
                    this.subGeneratorLists.set(index, this.generatorFactory.newSessionGeneratorForKey(this.randomGenerator.chooseRandomElement(this.sessionKeys), this.getWatermark()));
                } else {
                    this.subGeneratorLists.remove(index);
                }
            }
            return event;
        }
        throw new IllegalStateException("Unable to find an open sub-generator that can produce events");
    }

    public long getWatermark() {
        long watermark = Long.MAX_VALUE;
        for (EventGenerator<K, E> eventGenerator : this.subGeneratorLists) {
            watermark = Math.min(watermark, eventGenerator.getLocalWatermark());
        }
        return watermark;
    }

    private void initParallelSessionGenerators(int parallelSessions) {
        for (int i = 0; i < parallelSessions && (long)this.generatorFactory.getProducedGeneratorsCount() < this.sessionCountLimit; ++i) {
            this.subGeneratorLists.add(this.generatorFactory.newSessionGeneratorForKey(this.randomGenerator.chooseRandomElement(this.sessionKeys), 0L));
        }
    }
}

