/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.state.operator.restore.keyed;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.test.state.operator.restore.AbstractOperatorRestoreTestBase;
import org.apache.flink.test.state.operator.restore.ExecutionMode;
import org.apache.flink.test.state.operator.restore.keyed.KeyedJob;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractKeyedOperatorRestoreTestBase
extends AbstractOperatorRestoreTestBase {
    private final MigrationVersion migrationVersion;

    @Parameterized.Parameters(name="Migrate Savepoint: {0}")
    public static Collection<MigrationVersion> parameters() {
        return Arrays.asList(MigrationVersion.v1_3, MigrationVersion.v1_4, MigrationVersion.v1_5, MigrationVersion.v1_6, MigrationVersion.v1_7, MigrationVersion.v1_8, MigrationVersion.v1_9, MigrationVersion.v1_10, MigrationVersion.v1_11, MigrationVersion.v1_12, MigrationVersion.v1_13);
    }

    public AbstractKeyedOperatorRestoreTestBase(MigrationVersion migrationVersion) {
        this.migrationVersion = migrationVersion;
    }

    @Override
    public void createMigrationJob(StreamExecutionEnvironment env) {
        SingleOutputStreamOperator<Tuple2<Integer, Integer>> source = KeyedJob.createIntegerTupleSource(env, ExecutionMode.MIGRATE);
        SingleOutputStreamOperator<Integer> window = KeyedJob.createWindowFunction(ExecutionMode.MIGRATE, source);
        SingleOutputStreamOperator<Integer> first = KeyedJob.createFirstStatefulMap(ExecutionMode.MIGRATE, window);
        SingleOutputStreamOperator<Integer> second = KeyedJob.createSecondStatefulMap(ExecutionMode.MIGRATE, first);
    }

    @Override
    protected String getMigrationSavepointName() {
        return "complexKeyed-flink" + this.migrationVersion;
    }
}

