/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.optimizer.jsonplan;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.examples.java.clustering.KMeans;
import org.apache.flink.examples.java.graph.ConnectedComponents;
import org.apache.flink.examples.java.relational.WebLogAnalysis;
import org.apache.flink.examples.java.wordcount.WordCount;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.jsonplan.JsonPlanGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JsonJobGraphGenerationTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private PrintStream out;
    private PrintStream err;

    @Before
    public void redirectStreams() {
        this.out = System.out;
        this.err = System.err;
        OutputStream discards = new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
        System.setOut(new PrintStream(discards));
        System.setErr(new PrintStream(discards));
    }

    @After
    public void restoreStreams() {
        if (this.out != null) {
            System.setOut(this.out);
        }
        if (this.err != null) {
            System.setOut(this.err);
        }
    }

    @Test
    public void testWordCountPlan() {
        try {
            GenericValidator validator;
            int parallelism2;
            try {
                parallelism2 = 1;
                validator = new GenericValidator(1, 3);
                TestingExecutionEnvironment.setAsNext(validator, 1);
                WordCount.main((String[])new String[0]);
            }
            catch (AbortError parallelism2) {
                // empty catch block
            }
            try {
                parallelism2 = 17;
                validator = new GenericValidator(17, 3);
                TestingExecutionEnvironment.setAsNext(validator, 17);
                String tmpDir = this.tempFolder.newFolder().getAbsolutePath();
                WordCount.main((String[])new String[]{"--input", tmpDir, "--output", tmpDir});
            }
            catch (AbortError parallelism3) {}
        }
        catch (Exception e) {
            this.restoreStreams();
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWebLogAnalysis() {
        try {
            GenericValidator validator;
            int parallelism2;
            try {
                parallelism2 = 1;
                validator = new GenericValidator(1, 6);
                TestingExecutionEnvironment.setAsNext(validator, 1);
                WebLogAnalysis.main((String[])new String[0]);
            }
            catch (AbortError parallelism2) {
                // empty catch block
            }
            try {
                parallelism2 = 17;
                validator = new GenericValidator(17, 6);
                TestingExecutionEnvironment.setAsNext(validator, 17);
                String tmpDir = this.tempFolder.newFolder().getAbsolutePath();
                WebLogAnalysis.main((String[])new String[]{"--documents", tmpDir, "--ranks", tmpDir, "--visits", tmpDir, "--output", tmpDir});
            }
            catch (AbortError parallelism3) {}
        }
        catch (Exception e) {
            this.restoreStreams();
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testKMeans() {
        try {
            GenericValidator validator;
            int parallelism2;
            try {
                parallelism2 = 1;
                validator = new GenericValidator(1, 9);
                TestingExecutionEnvironment.setAsNext(validator, 1);
                KMeans.main((String[])new String[0]);
            }
            catch (AbortError parallelism2) {
                // empty catch block
            }
            try {
                parallelism2 = 42;
                validator = new GenericValidator(42, 9);
                TestingExecutionEnvironment.setAsNext(validator, 42);
                String tmpDir = this.tempFolder.newFolder().getAbsolutePath();
                KMeans.main((String[])new String[]{"--points", tmpDir, "--centroids", tmpDir, "--output", tmpDir, "--iterations", "100"});
            }
            catch (AbortError parallelism3) {}
        }
        catch (Exception e) {
            this.restoreStreams();
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectedComponents() {
        try {
            GenericValidator validator;
            int parallelism2;
            try {
                parallelism2 = 1;
                validator = new GenericValidator(1, 9);
                TestingExecutionEnvironment.setAsNext(validator, 1);
                ConnectedComponents.main((String[])new String[0]);
            }
            catch (AbortError parallelism2) {
                // empty catch block
            }
            try {
                parallelism2 = 23;
                validator = new GenericValidator(23, 9);
                TestingExecutionEnvironment.setAsNext(validator, 23);
                String tmpDir = this.tempFolder.newFolder().getAbsolutePath();
                ConnectedComponents.main((String[])new String[]{"--vertices", tmpDir, "--edges", tmpDir, "--output", tmpDir, "--iterations", "100"});
            }
            catch (AbortError parallelism3) {}
        }
        catch (Exception e) {
            this.restoreStreams();
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static class TestingExecutionEnvironment
    extends ExecutionEnvironment {
        private final JsonValidator validator;

        private TestingExecutionEnvironment(JsonValidator validator) {
            this.validator = validator;
        }

        public JobExecutionResult execute(String jobName) throws Exception {
            Plan plan = this.createProgramPlan(jobName);
            Optimizer pc = new Optimizer(new Configuration());
            OptimizedPlan op = pc.compile(plan);
            JobGraphGenerator jgg = new JobGraphGenerator();
            JobGraph jobGraph = jgg.compileJobGraph(op);
            String jsonPlan = JsonPlanGenerator.generatePlan((JobGraph)jobGraph);
            JsonParser parser = new JsonFactory().createJsonParser(jsonPlan);
            while (parser.nextToken() != null) {
            }
            this.validator.validateJson(jsonPlan);
            throw new AbortError();
        }

        public static void setAsNext(final JsonValidator validator, final int defaultParallelism) {
            TestingExecutionEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)new ExecutionEnvironmentFactory(){

                public ExecutionEnvironment createExecutionEnvironment() {
                    TestingExecutionEnvironment env = new TestingExecutionEnvironment(validator);
                    env.setParallelism(defaultParallelism);
                    return env;
                }
            });
        }
    }

    private static class AbortError
    extends Error {
        private static final long serialVersionUID = 152179957828703919L;

        private AbortError() {
        }
    }

    private static class GenericValidator
    implements JsonValidator {
        private final int expectedParallelism;
        private final int numNodes;

        GenericValidator(int expectedParallelism, int numNodes) {
            this.expectedParallelism = expectedParallelism;
            this.numNodes = numNodes;
        }

        @Override
        public void validateJson(String json) throws Exception {
            HashMap<String, JsonNode> idToNode = new HashMap<String, JsonNode>();
            ObjectMapper m = new ObjectMapper();
            JsonNode rootNode = m.readTree(json);
            JsonNode idField = rootNode.get("jid");
            JsonNode nameField = rootNode.get("name");
            JsonNode arrayField = rootNode.get("nodes");
            Assert.assertNotNull((Object)idField);
            Assert.assertNotNull((Object)nameField);
            Assert.assertNotNull((Object)arrayField);
            Assert.assertTrue((boolean)idField.isTextual());
            Assert.assertTrue((boolean)nameField.isTextual());
            Assert.assertTrue((boolean)arrayField.isArray());
            ArrayNode array = (ArrayNode)arrayField;
            Iterator iter = array.elements();
            while (iter.hasNext()) {
                JsonNode vertex = (JsonNode)iter.next();
                JsonNode vertexIdField = vertex.get("id");
                JsonNode parallelismField = vertex.get("parallelism");
                JsonNode contentsFields = vertex.get("description");
                JsonNode operatorField = vertex.get("operator");
                Assert.assertNotNull((Object)vertexIdField);
                Assert.assertTrue((boolean)vertexIdField.isTextual());
                Assert.assertNotNull((Object)parallelismField);
                Assert.assertTrue((boolean)parallelismField.isNumber());
                Assert.assertNotNull((Object)contentsFields);
                Assert.assertTrue((boolean)contentsFields.isTextual());
                Assert.assertNotNull((Object)operatorField);
                Assert.assertTrue((boolean)operatorField.isTextual());
                if (contentsFields.asText().startsWith("Sync")) {
                    Assert.assertEquals((long)1L, (long)parallelismField.asInt());
                } else {
                    Assert.assertEquals((long)this.expectedParallelism, (long)parallelismField.asInt());
                }
                idToNode.put(vertexIdField.asText(), vertex);
            }
            Assert.assertEquals((long)this.numNodes, (long)idToNode.size());
            for (JsonNode node : idToNode.values()) {
                JsonNode inputsField = node.get("inputs");
                if (inputsField == null) continue;
                Iterator inputsIter = inputsField.elements();
                while (inputsIter.hasNext()) {
                    JsonNode inputNode = (JsonNode)inputsIter.next();
                    JsonNode inputIdField = inputNode.get("id");
                    Assert.assertNotNull((Object)inputIdField);
                    Assert.assertTrue((boolean)inputIdField.isTextual());
                    String inputIdString = inputIdField.asText();
                    Assert.assertTrue((boolean)idToNode.containsKey(inputIdString));
                }
            }
        }
    }

    private static interface JsonValidator {
        public void validateJson(String var1) throws Exception;
    }
}

