/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.operators;

import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.utils.DataSetUtils;
import org.apache.flink.test.operators.util.CollectionDataSets;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SampleITCase
extends MultipleProgramsTestBase {
    private static final Random RNG = new Random();

    public SampleITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }

    @Before
    public void initiate() {
        ExecutionEnvironment.getExecutionEnvironment().setParallelism(5);
    }

    @Test
    public void testSamplerWithFractionWithoutReplacement() throws Exception {
        this.verifySamplerWithFractionWithoutReplacement(0.0);
        this.verifySamplerWithFractionWithoutReplacement(0.2);
        this.verifySamplerWithFractionWithoutReplacement(1.0);
    }

    @Test
    public void testSamplerWithFractionWithReplacement() throws Exception {
        this.verifySamplerWithFractionWithReplacement(0.0);
        this.verifySamplerWithFractionWithReplacement(0.2);
        this.verifySamplerWithFractionWithReplacement(1.0);
        this.verifySamplerWithFractionWithReplacement(2.0);
    }

    @Test
    public void testSamplerWithSizeWithoutReplacement() throws Exception {
        this.verifySamplerWithFixedSizeWithoutReplacement(0);
        this.verifySamplerWithFixedSizeWithoutReplacement(2);
        this.verifySamplerWithFixedSizeWithoutReplacement(21);
    }

    @Test
    public void testSamplerWithSizeWithReplacement() throws Exception {
        this.verifySamplerWithFixedSizeWithReplacement(0);
        this.verifySamplerWithFixedSizeWithReplacement(2);
        this.verifySamplerWithFixedSizeWithReplacement(21);
    }

    private void verifySamplerWithFractionWithoutReplacement(double fraction) throws Exception {
        this.verifySamplerWithFractionWithoutReplacement(fraction, RNG.nextLong());
    }

    private void verifySamplerWithFractionWithoutReplacement(double fraction, long seed) throws Exception {
        this.verifySamplerWithFraction(false, fraction, seed);
    }

    private void verifySamplerWithFractionWithReplacement(double fraction) throws Exception {
        this.verifySamplerWithFractionWithReplacement(fraction, RNG.nextLong());
    }

    private void verifySamplerWithFractionWithReplacement(double fraction, long seed) throws Exception {
        this.verifySamplerWithFraction(true, fraction, seed);
    }

    private void verifySamplerWithFraction(boolean withReplacement, double fraction, long seed) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        FlatMapOperator<Tuple3<Integer, Long, String>, String> ds = this.getSourceDataSet(env);
        MapPartitionOperator sampled = DataSetUtils.sample(ds, (boolean)withReplacement, (double)fraction, (long)seed);
        List result = sampled.collect();
        SampleITCase.containsResultAsText((List)result, (String)this.getSourceStrings());
    }

    private void verifySamplerWithFixedSizeWithoutReplacement(int numSamples) throws Exception {
        this.verifySamplerWithFixedSizeWithoutReplacement(numSamples, RNG.nextLong());
    }

    private void verifySamplerWithFixedSizeWithoutReplacement(int numSamples, long seed) throws Exception {
        this.verifySamplerWithFixedSize(false, numSamples, seed);
    }

    private void verifySamplerWithFixedSizeWithReplacement(int numSamples) throws Exception {
        this.verifySamplerWithFixedSizeWithReplacement(numSamples, RNG.nextLong());
    }

    private void verifySamplerWithFixedSizeWithReplacement(int numSamples, long seed) throws Exception {
        this.verifySamplerWithFixedSize(true, numSamples, seed);
    }

    private void verifySamplerWithFixedSize(boolean withReplacement, int numSamples, long seed) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        FlatMapOperator<Tuple3<Integer, Long, String>, String> ds = this.getSourceDataSet(env);
        DataSet sampled = DataSetUtils.sampleWithSize(ds, (boolean)withReplacement, (int)numSamples, (long)seed);
        List result = sampled.collect();
        Assert.assertEquals((long)numSamples, (long)result.size());
        SampleITCase.containsResultAsText((List)result, (String)this.getSourceStrings());
    }

    private FlatMapOperator<Tuple3<Integer, Long, String>, String> getSourceDataSet(ExecutionEnvironment env) {
        return CollectionDataSets.get3TupleDataSet(env).flatMap((FlatMapFunction)new FlatMapFunction<Tuple3<Integer, Long, String>, String>(){

            public void flatMap(Tuple3<Integer, Long, String> value, Collector<String> out) throws Exception {
                out.collect(value.f2);
            }
        });
    }

    private String getSourceStrings() {
        return "Hi\nHello\nHello world\nHello world, how are you?\nI am fine.\nLuke Skywalker\nComment#1\nComment#2\nComment#3\nComment#4\nComment#5\nComment#6\nComment#7\nComment#8\nComment#9\nComment#10\nComment#11\nComment#12\nComment#13\nComment#14\nComment#15\n";
    }
}

