/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.migration;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.RocksDBStateBackend;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.test.checkpointing.utils.MigrationTestUtils;
import org.apache.flink.test.checkpointing.utils.SavepointMigrationTestBase;
import org.apache.flink.testutils.migration.MigrationVersion;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TypeSerializerSnapshotMigrationITCase
extends SavepointMigrationTestBase {
    private static final int NUM_SOURCE_ELEMENTS = 4;
    private final ExecutionMode executionMode = ExecutionMode.VERIFY_SAVEPOINT;
    private final MigrationVersion testMigrateVersion;
    private final String testStateBackend;

    @Parameterized.Parameters(name="Migrate Savepoint / Backend: {0}")
    public static Collection<Tuple2<MigrationVersion, String>> parameters() {
        return Arrays.asList(Tuple2.of((Object)MigrationVersion.v1_3, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_3, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_4, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_4, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_5, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_5, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_6, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_6, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_7, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_7, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_8, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_8, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_9, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_9, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_10, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_10, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_11, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_11, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_12, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_12, (Object)"rocksdb"), Tuple2.of((Object)MigrationVersion.v1_13, (Object)"jobmanager"), Tuple2.of((Object)MigrationVersion.v1_13, (Object)"rocksdb"));
    }

    public TypeSerializerSnapshotMigrationITCase(Tuple2<MigrationVersion, String> testMigrateVersionAndBackend) throws Exception {
        this.testMigrateVersion = (MigrationVersion)testMigrateVersionAndBackend.f0;
        this.testStateBackend = (String)testMigrateVersionAndBackend.f1;
    }

    @Test
    public void testSavepoint() throws Exception {
        boolean parallelism = true;
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setRestartStrategy(RestartStrategies.noRestart());
        switch (this.testStateBackend) {
            case "rocksdb": {
                env.setStateBackend((StateBackend)new RocksDBStateBackend((AbstractStateBackend)new MemoryStateBackend()));
                break;
            }
            case "jobmanager": {
                env.setStateBackend((StateBackend)new MemoryStateBackend());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        env.enableCheckpointing(500L);
        env.setParallelism(1);
        env.setMaxParallelism(1);
        MigrationTestUtils.CheckpointingNonParallelSourceWithListState nonParallelSource = new MigrationTestUtils.CheckpointingNonParallelSourceWithListState(4);
        env.addSource((SourceFunction)nonParallelSource).keyBy(new int[]{0}).map((MapFunction)new TestMapFunction()).addSink(new MigrationTestUtils.AccumulatorCountingSink());
        if (this.executionMode == ExecutionMode.PERFORM_SAVEPOINT) {
            this.executeAndSavepoint(env, "src/test/resources/" + this.getSavepointPath(this.testMigrateVersion, this.testStateBackend), new Tuple2((Object)MigrationTestUtils.AccumulatorCountingSink.NUM_ELEMENTS_ACCUMULATOR, (Object)4));
        } else {
            this.restoreAndExecute(env, TypeSerializerSnapshotMigrationITCase.getResourceFilename(this.getSavepointPath(this.testMigrateVersion, this.testStateBackend)), new Tuple2((Object)MigrationTestUtils.AccumulatorCountingSink.NUM_ELEMENTS_ACCUMULATOR, (Object)4));
        }
    }

    private String getSavepointPath(MigrationVersion savepointVersion, String backendType) {
        switch (backendType) {
            case "rocksdb": {
                return "type-serializer-snapshot-migration-itcase-flink" + savepointVersion + "-rocksdb-savepoint";
            }
            case "jobmanager": {
                return "type-serializer-snapshot-migration-itcase-flink" + savepointVersion + "-savepoint";
            }
        }
        throw new UnsupportedOperationException();
    }

    public static class TestSerializerSnapshot
    implements TypeSerializerSnapshot<Long> {
        private String configPayload;

        public TestSerializerSnapshot() {
        }

        public TestSerializerSnapshot(String configPayload) {
            this.configPayload = configPayload;
        }

        public int getCurrentVersion() {
            return 1;
        }

        public TypeSerializerSchemaCompatibility<Long> resolveSchemaCompatibility(TypeSerializer<Long> newSerializer) {
            return newSerializer instanceof TestSerializer ? TypeSerializerSchemaCompatibility.compatibleAsIs() : TypeSerializerSchemaCompatibility.incompatible();
        }

        public TypeSerializer<Long> restoreSerializer() {
            return new TestSerializer();
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeUTF(this.configPayload);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            if (readVersion != 1) {
                throw new IllegalStateException("Can not recognize read version: " + readVersion);
            }
            this.configPayload = in.readUTF();
        }
    }

    private static class TestSerializer
    extends TypeSerializer<Long> {
        private static final long serialVersionUID = 1L;
        private LongSerializer serializer = new LongSerializer();
        private String configPayload = "configPayload";

        private TestSerializer() {
        }

        public TypeSerializerSnapshot<Long> snapshotConfiguration() {
            return new TestSerializerSnapshot(this.configPayload);
        }

        public TypeSerializer<Long> duplicate() {
            return this;
        }

        public void serialize(Long record, DataOutputView target) throws IOException {
            this.serializer.serialize(record, target);
        }

        public Long deserialize(Long reuse, DataInputView source) throws IOException {
            return this.serializer.deserialize(reuse, source);
        }

        public Long deserialize(DataInputView source) throws IOException {
            return this.serializer.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.serializer.copy(source, target);
        }

        public Long copy(Long from) {
            return this.serializer.copy(from);
        }

        public Long copy(Long from, Long reuse) {
            return this.serializer.copy(from, reuse);
        }

        public Long createInstance() {
            return this.serializer.createInstance();
        }

        public boolean isImmutableType() {
            return this.serializer.isImmutableType();
        }

        public int getLength() {
            return this.serializer.getLength();
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TestSerializer;
        }
    }

    private static class TestMapFunction
    extends RichMapFunction<Tuple2<Long, Long>, Tuple2<Long, Long>> {
        private static final long serialVersionUID = 1L;

        private TestMapFunction() {
        }

        public Tuple2<Long, Long> map(Tuple2<Long, Long> value) throws Exception {
            ValueState state = this.getRuntimeContext().getState(new ValueStateDescriptor("testState", (TypeSerializer)new TestSerializer()));
            state.update(value.f1);
            return value;
        }
    }

    public static enum ExecutionMode {
        PERFORM_SAVEPOINT,
        VERIFY_SAVEPOINT;

    }
}

