/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.operators;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.ExecutionEnvironment;
import org.apache.flink.api.scala.ExecutionEnvironment$;
import org.apache.flink.api.scala.operators.ReduceITCase$;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.util.CollectionDataSets;
import org.apache.flink.api.scala.util.CollectionDataSets$;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001=\u0011ABU3ek\u000e,\u0017\nV\"bg\u0016T!a\u0001\u0003\u0002\u0013=\u0004XM]1u_J\u001c(BA\u0003\u0007\u0003\u0015\u00198-\u00197b\u0015\t9\u0001\"A\u0002ba&T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)\u0002\"\u0001\u0003uKN$\u0018BA\f\u0013\u0005aiU\u000f\u001c;ja2,\u0007K]8he\u0006l7\u000fV3ti\n\u000b7/\u001a\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005!Qn\u001c3f!\tY2F\u0004\u0002\u001dS9\u0011Q\u0004\u000b\b\u0003=\u001dr!a\b\u0014\u000f\u0005\u0001*cBA\u0011%\u001b\u0005\u0011#BA\u0012\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003+!I!a\u0005\u000b\n\u0005)\u0012\u0012\u0001G'vYRL\u0007\u000f\\3Qe><'/Y7t)\u0016\u001cHOQ1tK&\u0011A&\f\u0002\u0012)\u0016\u001cH/\u0012=fGV$\u0018n\u001c8N_\u0012,'B\u0001\u0016\u0013\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q\u0011\u0011g\r\t\u0003e\u0001i\u0011A\u0001\u0005\u000639\u0002\rA\u0007\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0003)\u0011Xm];miB\u000bG\u000f[\u000b\u0002oA\u0011\u0001(\u0010\b\u0003sm\u0002\"!\t\u001e\u000b\u0003\u0015I!\u0001\u0010\u001e\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yiBq!\u0011\u0001A\u0002\u0013%!)\u0001\bsKN,H\u000e\u001e)bi\"|F%Z9\u0015\u0005\r;\u0005C\u0001#F\u001b\u0005Q\u0014B\u0001$;\u0005\u0011)f.\u001b;\t\u000f!\u0003\u0015\u0011!a\u0001o\u0005\u0019\u0001\u0010J\u0019\t\r)\u0003\u0001\u0015)\u00038\u0003-\u0011Xm];miB\u000bG\u000f\u001b\u0011\t\u000f1\u0003\u0001\u0019!C\u0005m\u0005AQ\r\u001f9fGR,G\rC\u0004O\u0001\u0001\u0007I\u0011B(\u0002\u0019\u0015D\b/Z2uK\u0012|F%Z9\u0015\u0005\r\u0003\u0006b\u0002%N\u0003\u0003\u0005\ra\u000e\u0005\u0007%\u0002\u0001\u000b\u0015B\u001c\u0002\u0013\u0015D\b/Z2uK\u0012\u0004\u0003b\u0002+\u0001\u0005\u0004%I!V\u0001\f?R,W\u000e\u001d$pY\u0012,'/F\u0001W!\t9F,D\u0001Y\u0015\tI&,A\u0003sk2,7O\u0003\u0002\\\u0019\u0005)!.\u001e8ji&\u0011Q\f\u0017\u0002\u0010)\u0016l\u0007o\u001c:bef4u\u000e\u001c3fe\"1q\f\u0001Q\u0001\nY\u000bAb\u0018;f[B4u\u000e\u001c3fe\u0002BQ!\u0019\u0001\u0005\u0002U\u000b!\u0002^3na\u001a{G\u000eZ3sQ\t\u00017\r\u0005\u0002eK6\t!,\u0003\u0002g5\n!!+\u001e7f\u0011\u0015A\u0007\u0001\"\u0001j\u0003\u0019\u0011WMZ8sKR\t1\t\u000b\u0002hWB\u0011A\r\\\u0005\u0003[j\u0013aAQ3g_J,\u0007\"B8\u0001\t\u0003I\u0017!B1gi\u0016\u0014\bF\u00018r!\t!'/\u0003\u0002t5\n)\u0011I\u001a;fe\")Q\u000f\u0001C\u0001S\u00061C/Z:u%\u0016$WoY3P]R+\b\u000f\\3t/&$\bnS3z\r&,G\u000eZ*fY\u0016\u001cGo\u001c:)\u0005Q<\bC\u00013y\u0013\tI(L\u0001\u0003UKN$\b\"B>\u0001\t\u0003I\u0017a\f;fgR\u0014V\rZ;dK>sG+\u001e9mKN<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f\u0017\u0016Lh)[3mIN+G.Z2u_J\u001c\bF\u0001>x\u0011\u0015q\b\u0001\"\u0001j\u0003\t\"Xm\u001d;SK\u0012,8-Z(o)V\u0004H.Z:XSRD7*Z=FqR\u0014\u0018m\u0019;pe\"\u0012Qp\u001e\u0005\u0007\u0003\u0007\u0001A\u0011A5\u0002MQ,7\u000f\u001e*fIV\u001cWm\u00148DkN$x.\u001c+za\u0016<\u0016\u000e\u001e5LKf,\u0005\u0010\u001e:bGR|'\u000fK\u0002\u0002\u0002]Da!!\u0003\u0001\t\u0003I\u0017!\u0006;fgR\fE\u000e\u001c*fIV\u001cWMR8s)V\u0004H.\u001a\u0015\u0004\u0003\u000f9\bBBA\b\u0001\u0011\u0005\u0011.A\u000euKN$\u0018\t\u001c7SK\u0012,8-\u001a$pe\u000e+8\u000f^8n)f\u0004Xm\u001d\u0015\u0004\u0003\u001b9\bBBA\u000b\u0001\u0011\u0005\u0011.\u0001\u000euKN$(+\u001a3vG\u0016<\u0016\u000e\u001e5Ce>\fGmY1tiN+G\u000fK\u0002\u0002\u0014]Da!a\u0007\u0001\t\u0003I\u0017\u0001\r;fgR\u0014V\rZ;dK^KG\u000f[+E\rRC\u0017\r\u001e*fiV\u0014hn\u001d+iKN+7m\u001c8e\u0013:\u0004X\u000f^(cU\u0016\u001cG\u000fK\u0002\u0002\u001a]Da!!\t\u0001\t\u0003I\u0017\u0001\u000b;fgR\u0014V\rZ;dK^KG\u000f[!UkBdWMU3ukJt\u0017N\\4LKf\u001cV\r\\3di>\u0014\bfAA\u0010o\"1\u0011q\u0005\u0001\u0005\u0002%\fA\u0005^3tiJ+G-^2f\u001f:<%o\\;qK\u0012$5KQ=FqB\u0014Xm]:j_:\\U-\u001f\u0015\u0004\u0003K9\bBBA\u0017\u0001\u0011\u0005\u0011.\u0001\u0019uKN$(+\u001a3vG\u0016|en\u0012:pkB,G\rR*Cs\u0016C\bO]3tg&|gnS3z/&$\b\u000eS1tQ\"Kg\u000e\u001e\u0015\u0004\u0003W9\bf\u0002\u0001\u00024\u0005}\u0012\u0011\t\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011\b.\u0002\rI,hN\\3s\u0013\u0011\ti$a\u000e\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u00111\t\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011\n.\u0002\u000fI,hN\\3sg&!\u0011QJA$\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u0002")
public class ReduceITCase
extends MultipleProgramsTestBase {
    private String resultPath = null;
    private String expected = null;
    private final TemporaryFolder _tempFolder = new TemporaryFolder();

    private String resultPath() {
        return this.resultPath;
    }

    private void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    private String expected() {
        return this.expected;
    }

    private void expected_$eq(String x$1) {
        this.expected = x$1;
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.expected(), (String)this.resultPath());
    }

    @Test
    public void testReduceOnTuplesWithKeyFieldSelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)"B-)"));
        String x$3 = this.resultPath();
        FileSystem.WriteMode x$4 = FileSystem.WriteMode.OVERWRITE;
        String x$5 = reduceDs.writeAsCsv$default$2();
        String x$6 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$3, x$5, x$6, x$4);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,B-)\n15,3,B-)\n34,4,B-)\n65,5,B-)\n111,6,B-)\n");
    }

    @Test
    public void testReduceOnTuplesWithMultipleKeyFieldSelectors() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0})).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5()));
        String x$7 = this.resultPath();
        FileSystem.WriteMode x$8 = FileSystem.WriteMode.OVERWRITE;
        String x$9 = reduceDs.writeAsCsv$default$2();
        String x$10 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$7, x$9, x$10, x$8);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    @Test
    public void testReduceOnTuplesWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)ReduceITCase.$anonfun$testReduceOnTuplesWithKeyExtractor$1(x$1)), (TypeInformation)BasicTypeInfo.getInfoFor(Long.TYPE)).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)"B-)"));
        String x$11 = this.resultPath();
        FileSystem.WriteMode x$12 = FileSystem.WriteMode.OVERWRITE;
        String x$13 = reduceDs.writeAsCsv$default$2();
        String x$14 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$11, x$13, x$14, x$12);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,B-)\n15,3,B-)\n34,4,B-)\n65,5,B-)\n111,6,B-)\n");
    }

    @Test
    public void testReduceOnCustomTypeWithKeyExtractor() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.myInt()), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> {
            in1.myLong_$eq(in1.myLong() + in2.myLong());
            in1.myString_$eq("Hello!");
            return in1;
        });
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("1,0,Hi\n2,3,Hello!\n3,12,Hello!\n4,30,Hello!\n5,60,Hello!\n6,105,Hello!\n");
    }

    @Test
    public void testAllReduceForTuple() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)"Hello World"));
        String x$15 = this.resultPath();
        FileSystem.WriteMode x$16 = FileSystem.WriteMode.OVERWRITE;
        String x$17 = reduceDs.writeAsCsv$default$2();
        String x$18 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$15, x$17, x$18, x$16);
        env.execute();
        this.expected_$eq("231,91,Hello World\n");
    }

    @Test
    public void testAllReduceForCustomTypes() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<CollectionDataSets.CustomType> ds = CollectionDataSets$.MODULE$.getCustomTypeDataSet(env);
        DataSet reduceDs = ds.reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> {
            in1.myInt_$eq(in1.myInt() + in2.myInt());
            in1.myLong_$eq(in1.myLong() + in2.myLong());
            in1.myString_$eq("Hello!");
            return in1;
        });
        reduceDs.writeAsText(this.resultPath(), FileSystem.WriteMode.OVERWRITE);
        env.execute();
        this.expected_$eq("91,210,Hello!");
    }

    @Test
    public void testReduceWithBroadcastSet() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Object> intDs = CollectionDataSets$.MODULE$.getIntDataSet(env);
        DataSet<Tuple3<Object, Object, String>> ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((ReduceFunction)new RichReduceFunction<Tuple3<Object, Object, String>>(null){
            private String f2Replace;

            private String f2Replace() {
                return this.f2Replace;
            }

            private void f2Replace_$eq(String x$1) {
                this.f2Replace = x$1;
            }

            public void open(Configuration config) {
                Buffer ints = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.getRuntimeContext().getBroadcastVariable("ints")).asScala();
                this.f2Replace_$eq(new StringBuilder(0).append(BoxesRunTime.unboxToInt((Object)ints.sum((Numeric)Numeric.IntIsIntegral$.MODULE$))).toString());
            }

            public Tuple3<Object, Object, String> reduce(Tuple3<Object, Object, String> in1, Tuple3<Object, Object, String> in2) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))), in1._2(), (Object)this.f2Replace());
            }
            {
                this.f2Replace = "";
            }
        }).withBroadcastSet(intDs, "ints");
        String x$19 = this.resultPath();
        FileSystem.WriteMode x$20 = FileSystem.WriteMode.OVERWRITE;
        String x$21 = reduceDs.writeAsCsv$default$2();
        String x$22 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$19, x$21, x$22, x$20);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,55\n15,3,55\n34,4,55\n65,5,55\n111,6,55\n");
    }

    @Test
    public void testReduceWithUDFThatReturnsTheSecondInputObject() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet ds = CollectionDataSets$.MODULE$.get3TupleDataSet(env).map((Function1 & Serializable & scala.Serializable)t -> new CollectionDataSets.MutableTuple3<Object, Object, Object>(t._1(), t._2(), t._3()), (TypeInformation)new CaseClassTypeInfo<CollectionDataSets.MutableTuple3<Object, Object, String>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$5 x$1) {
                return x$1.types;
            }

            public TypeSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>> unused = new ScalaCaseClassSerializer<CollectionDataSets.MutableTuple3<Object, Object, String>>(this, fieldSerializers){

                    public CollectionDataSets.MutableTuple3<Object, Object, String> createInstance(Object[] fields) {
                        return new CollectionDataSets.MutableTuple3<Object, Object, String>(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[1])), (String)fields[2]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.api.scala.operators.ReduceITCase$$anon$5 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }, ClassTag$.MODULE$.apply(CollectionDataSets.MutableTuple3.class));
        DataSet reduceDs = ds.groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).reduce((ReduceFunction)new RichReduceFunction<CollectionDataSets.MutableTuple3<Object, Object, String>>(null){

            public CollectionDataSets.MutableTuple3<Object, Object, String> reduce(CollectionDataSets.MutableTuple3<Object, Object, String> in1, CollectionDataSets.MutableTuple3<Object, Object, String> in2) {
                in2._1_$eq(BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)in1._1()) + BoxesRunTime.unboxToInt((Object)in2._1()))));
                in2._3_$eq("Hi again!");
                return in2;
            }
        });
        String x$23 = this.resultPath();
        FileSystem.WriteMode x$24 = FileSystem.WriteMode.OVERWRITE;
        String x$25 = reduceDs.writeAsCsv$default$2();
        String x$26 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$23, x$25, x$26, x$24);
        env.execute();
        this.expected_$eq("1,1,Hi\n5,2,Hi again!\n15,3,Hi again!\n34,4,Hi again!\n65,5,Hi again!\n111,6,Hi again!\n");
    }

    @Test
    public void testReduceWithATupleReturningKeySelector() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy((Function1 & Serializable & scala.Serializable)t -> new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)t._1()), BoxesRunTime.unboxToLong((Object)t._5())), (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(null){

            public /* synthetic */ TypeInformation[] protected$types($anon$6 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcIJ.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.api.scala.operators.ReduceITCase$$anon$6 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5()));
        String x$27 = this.resultPath();
        FileSystem.WriteMode x$28 = FileSystem.WriteMode.OVERWRITE;
        String x$29 = reduceDs.writeAsCsv$default$2();
        String x$30 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$27, x$29, x$30, x$28);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    @Test
    public void testReduceOnGroupedDSByExpressionKey() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy("_5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1"})).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5()));
        String x$31 = this.resultPath();
        FileSystem.WriteMode x$32 = FileSystem.WriteMode.OVERWRITE;
        String x$33 = reduceDs.writeAsCsv$default$2();
        String x$34 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$31, x$33, x$34, x$32);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    @Test
    public void testReduceOnGroupedDSByExpressionKeyWithHashHint() {
        ExecutionEnvironment env = ExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataSet<Tuple5<Object, Object, Object, String, Object>> ds = CollectionDataSets$.MODULE$.get5TupleDataSet(env);
        DataSet reduceDs = ds.groupBy("_5", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_1"})).reduce((Function2 & Serializable & scala.Serializable)(in1, in2) -> new Tuple5(in1._1(), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)in1._2()) + BoxesRunTime.unboxToLong((Object)in2._2()))), (Object)BoxesRunTime.boxToInteger((int)0), (Object)"P-)", in1._5()), ReduceOperatorBase.CombineHint.HASH);
        String x$35 = this.resultPath();
        FileSystem.WriteMode x$36 = FileSystem.WriteMode.OVERWRITE;
        String x$37 = reduceDs.writeAsCsv$default$2();
        String x$38 = reduceDs.writeAsCsv$default$3();
        reduceDs.writeAsCsv(x$35, x$37, x$38, x$36);
        env.execute();
        this.expected_$eq("1,1,0,Hallo,1\n2,3,2,Hallo Welt wie,1\n2,2,1,Hallo Welt,2\n3,9,0,P-),2\n3,6,5,BCD,3\n4,17,0,P-),1\n4,17,0,P-),2\n5,11,10,GHI,1\n5,29,0,P-),2\n5,25,0,P-),3\n");
    }

    public static final /* synthetic */ long $anonfun$testReduceOnTuplesWithKeyExtractor$1(Tuple3 x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1._2());
    }

    public ReduceITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

