/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.functions;

import org.apache.flink.api.scala.functions.TestClass;
import org.apache.flink.api.scala.functions.TestClassWithNesting;
import org.apache.flink.api.scala.functions.TestClassWithoutDefaultConstructor;
import org.apache.flink.api.scala.functions.TestClassWithoutFieldAccess;
import org.apache.flink.api.scala.functions.TestObject$;
import org.apache.flink.api.scala.functions.TestObjectWithBogusReturns$;
import org.apache.flink.api.scala.functions.TestObjectWithNestedReturns$;
import org.apache.flink.api.scala.functions.TestObjectWithNesting$;
import org.apache.flink.test.util.MultipleProgramsTestBase;
import org.apache.flink.test.util.TestBaseUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.reflect.ScalaSignature;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001=\u0011Ac\u00117pgV\u0014Xm\u00117fC:,'/\u0013+DCN,'BA\u0002\u0005\u0003%1WO\\2uS>t7O\u0003\u0002\u0006\r\u0005)1oY1mC*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA!\u001e;jY*\u0011Q\u0003C\u0001\u0005i\u0016\u001cH/\u0003\u0002\u0018%\tAR*\u001e7uSBdW\r\u0015:pOJ\fWn\u001d+fgR\u0014\u0015m]3\t\u0011e\u0001!\u0011!Q\u0001\ni\tA!\\8eKB\u00111d\u000b\b\u00039%r!!\b\u0015\u000f\u0005y9cBA\u0010'\u001d\t\u0001SE\u0004\u0002\"I5\t!E\u0003\u0002$\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005UA\u0011BA\n\u0015\u0013\tQ##\u0001\rNk2$\u0018\u000e\u001d7f!J|wM]1ngR+7\u000f\u001e\"bg\u0016L!\u0001L\u0017\u0003#Q+7\u000f^#yK\u000e,H/[8o\u001b>$WM\u0003\u0002+%!)q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\u0002\t\u000beq\u0003\u0019\u0001\u000e\t\u000fU\u0002!\u0019!C\u0001m\u0005Yq\f^3na\u001a{G\u000eZ3s+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0015\u0011X\u000f\\3t\u0015\taD\"A\u0003kk:LG/\u0003\u0002?s\tyA+Z7q_J\f'/\u001f$pY\u0012,'\u000f\u0003\u0004A\u0001\u0001\u0006IaN\u0001\r?R,W\u000e\u001d$pY\u0012,'\u000f\t\u0005\n\u0005\u0002\u0001\r\u00111A\u0005\u0002\r\u000b!B]3tk2$\b+\u0019;i+\u0005!\u0005CA#K\u001d\t1\u0005\n\u0005\u0002\"\u000f*\tQ!\u0003\u0002J\u000f\u00061\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIu\tC\u0005O\u0001\u0001\u0007\t\u0019!C\u0001\u001f\u0006q!/Z:vYR\u0004\u0016\r\u001e5`I\u0015\fHC\u0001)U!\t\t&+D\u0001H\u0013\t\u0019vI\u0001\u0003V]&$\bbB+N\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\n\u0004\"C,\u0001\u0001\u0004\u0005\t\u0015)\u0003E\u0003-\u0011Xm];miB\u000bG\u000f\u001b\u0011\t\u0013e\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0015A\u0002:fgVdG\u000fC\u0005\\\u0001\u0001\u0007\t\u0019!C\u00019\u0006Q!/Z:vYR|F%Z9\u0015\u0005Ak\u0006bB+[\u0003\u0003\u0005\r\u0001\u0012\u0005\n?\u0002\u0001\r\u0011!Q!\n\u0011\u000bqA]3tk2$\b\u0005C\u0003b\u0001\u0011\u0005a'\u0001\u0006uK6\u0004hi\u001c7eKJD#\u0001Y2\u0011\u0005\u0011,W\"A\u001e\n\u0005\u0019\\$\u0001\u0002*vY\u0016DQ\u0001\u001b\u0001\u0005\u0002%\faAY3g_J,G#\u0001))\u0005\u001d\\\u0007C\u00013m\u0013\ti7H\u0001\u0004CK\u001a|'/\u001a\u0005\u0006_\u0002!\t![\u0001\u0006C\u001a$XM\u001d\u0015\u0003]F\u0004\"\u0001\u001a:\n\u0005M\\$!B!gi\u0016\u0014\b\"B;\u0001\t\u0003I\u0017A\u0003;fgR|%M[3di\"\u0012Ao\u001e\t\u0003IbL!!_\u001e\u0003\tQ+7\u000f\u001e\u0005\u0006w\u0002!\t![\u0001\ni\u0016\u001cHo\u00117bgND#A_<\t\u000by\u0004A\u0011A5\u0002CQ,7\u000f^\"mCN\u001cx+\u001b;i_V$H)\u001a4bk2\u001cuN\\:ueV\u001cGo\u001c:)\u0005u<\bBBA\u0002\u0001\u0011\u0005\u0011.A\u000euKN$8\t\\1tg^KG\u000f[8vi\u001aKW\r\u001c3BG\u000e,7o\u001d\u0015\u0004\u0003\u00039\bBBA\u0005\u0001\u0011\u0005\u0011.A\u000buKN$xJ\u00196fGR<\u0016\u000e\u001e5OKN$\u0018N\\4)\u0007\u0005\u001dq\u000f\u0003\u0004\u0002\u0010\u0001!\t![\u0001\u0015i\u0016\u001cHo\u00117bgN<\u0016\u000e\u001e5OKN$\u0018N\\4)\u0007\u00055q\u000f\u0003\u0004\u0002\u0016\u0001!\t![\u0001\u001bi\u0016\u001cHo\u00142kK\u000e$x+\u001b;i\u0005><Wo\u001d*fiV\u0014hn\u001d\u0015\u0004\u0003'9\bBBA\u000e\u0001\u0011\u0005\u0011.A\u000euKN$xJ\u00196fGR<\u0016\u000e\u001e5OKN$X\r\u001a*fiV\u0014hn\u001d\u0015\u0004\u000339\bf\u0002\u0001\u0002\"\u00055\u0012q\u0006\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE\u001e\u0002\rI,hN\\3s\u0013\u0011\tY#!\n\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\u0012\u0011\u0011\u0007\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011qG\u001e\u0002\u000fI,hN\\3sg&!\u00111HA\u001b\u00055\u0001\u0016M]1nKR,'/\u001b>fI\u0002")
public class ClosureCleanerITCase
extends MultipleProgramsTestBase {
    private final TemporaryFolder _tempFolder = new TemporaryFolder();
    private String resultPath;
    private String result;

    public TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    public String resultPath() {
        return this.resultPath;
    }

    public void resultPath_$eq(String x$1) {
        this.resultPath = x$1;
    }

    public String result() {
        return this.result;
    }

    public void result_$eq(String x$1) {
        this.result = x$1;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    @Before
    public void before() {
        this.resultPath_$eq(this.tempFolder().newFile().toURI().toString());
    }

    @After
    public void after() {
        TestBaseUtils.compareResultsByLinesInMemory((String)this.result(), (String)this.resultPath());
    }

    @Test
    public void testObject() {
        TestObject$.MODULE$.run(this.resultPath());
        this.result_$eq("30");
    }

    @Test
    public void testClass() {
        TestClass obj = new TestClass();
        obj.run(this.resultPath());
        this.result_$eq("30");
    }

    @Test
    public void testClassWithoutDefaulConstructor() {
        TestClassWithoutDefaultConstructor obj = new TestClassWithoutDefaultConstructor(5);
        obj.run(this.resultPath());
        this.result_$eq("30");
    }

    @Test
    public void testClassWithoutFieldAccess() {
        TestClassWithoutFieldAccess obj = new TestClassWithoutFieldAccess();
        obj.run(this.resultPath());
        this.result_$eq("30");
    }

    @Test
    public void testObjectWithNesting() {
        TestObjectWithNesting$.MODULE$.run(this.resultPath());
        this.result_$eq("27");
    }

    @Test
    public void testClassWithNesting() {
        TestClassWithNesting obj = new TestClassWithNesting(1);
        obj.run(this.resultPath());
        this.result_$eq("27");
    }

    @Test
    public void testObjectWithBogusReturns() {
        TestObjectWithBogusReturns$.MODULE$.run(this.resultPath());
        this.result_$eq("1");
    }

    @Test
    public void testObjectWithNestedReturns() {
        TestObjectWithNestedReturns$.MODULE$.run(this.resultPath());
        this.result_$eq("1");
    }

    public ClosureCleanerITCase(MultipleProgramsTestBase.TestExecutionMode mode) {
        super(mode);
    }
}

