/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.testutils.org.jboss.netty.channel.local;

import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.AbstractChannel;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelConfig;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelException;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelFactory;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelFuture;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.ChannelSink;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.Channels;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.DefaultChannelConfig;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.MessageEvent;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.local.LocalAddress;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.local.LocalChannel;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.local.LocalChannelRegistry;
import org.apache.flink.shaded.testutils.org.jboss.netty.channel.local.LocalServerChannel;
import org.apache.flink.shaded.testutils.org.jboss.netty.util.internal.ThreadLocalBoolean;

final class DefaultLocalChannel
extends AbstractChannel
implements LocalChannel {
    private static final int ST_OPEN = 0;
    private static final int ST_BOUND = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_CLOSED = -1;
    final AtomicInteger state = new AtomicInteger(0);
    private final ChannelConfig config;
    private final ThreadLocalBoolean delivering = new ThreadLocalBoolean();
    final Queue<MessageEvent> writeBuffer = new ConcurrentLinkedQueue<MessageEvent>();
    volatile DefaultLocalChannel pairedChannel;
    volatile LocalAddress localAddress;
    volatile LocalAddress remoteAddress;

    DefaultLocalChannel(LocalServerChannel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, DefaultLocalChannel pairedChannel) {
        super(parent, factory, pipeline, sink);
        this.pairedChannel = pairedChannel;
        this.config = new DefaultChannelConfig();
        this.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                DefaultLocalChannel.this.state.set(-1);
            }
        });
        Channels.fireChannelOpen(this);
    }

    public ChannelConfig getConfig() {
        return this.config;
    }

    public boolean isOpen() {
        return this.state.get() >= 0;
    }

    public boolean isBound() {
        return this.state.get() >= 1;
    }

    public boolean isConnected() {
        return this.state.get() == 2;
    }

    void setBound() throws ClosedChannelException {
        if (!this.state.compareAndSet(0, 1)) {
            switch (this.state.get()) {
                case -1: {
                    throw new ClosedChannelException();
                }
            }
            throw new ChannelException("already bound");
        }
    }

    void setConnected() {
        if (this.state.get() != -1) {
            this.state.set(2);
        }
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    public LocalAddress getLocalAddress() {
        return this.localAddress;
    }

    public LocalAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void closeNow(ChannelFuture future) {
        LocalAddress localAddress;
        block8: {
            block7: {
                block6: {
                    localAddress = this.localAddress;
                    try {
                        if (!this.setClosed()) {
                            Object var6_3 = null;
                            future.setSuccess();
                            break block6;
                        }
                        DefaultLocalChannel pairedChannel = this.pairedChannel;
                        if (pairedChannel != null) {
                            this.pairedChannel = null;
                            Channels.fireChannelDisconnected(this);
                            Channels.fireChannelUnbound(this);
                        }
                        Channels.fireChannelClosed(this);
                        if (pairedChannel == null) break block7;
                        if (!pairedChannel.setClosed()) {
                            break block7;
                        }
                        DefaultLocalChannel me = pairedChannel.pairedChannel;
                        if (me != null) {
                            pairedChannel.pairedChannel = null;
                            Channels.fireChannelDisconnected(pairedChannel);
                            Channels.fireChannelUnbound(pairedChannel);
                        }
                        Channels.fireChannelClosed(pairedChannel);
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        future.setSuccess();
                        if (localAddress == null) throw throwable;
                        if (this.getParent() != null) throw throwable;
                        LocalChannelRegistry.unregister(localAddress);
                        throw throwable;
                    }
                }
                if (localAddress == null) return;
                if (this.getParent() != null) return;
                LocalChannelRegistry.unregister(localAddress);
                return;
            }
            Object var6_4 = null;
            future.setSuccess();
            if (localAddress == null) return;
            if (this.getParent() != null) return;
            LocalChannelRegistry.unregister(localAddress);
            return;
        }
        Object var6_5 = null;
        future.setSuccess();
        if (localAddress == null) return;
        if (this.getParent() != null) return;
        LocalChannelRegistry.unregister(localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushWriteBuffer() {
        DefaultLocalChannel pairedChannel = this.pairedChannel;
        if (pairedChannel != null) {
            if (pairedChannel.isConnected() && !((Boolean)this.delivering.get()).booleanValue()) {
                this.delivering.set(true);
                try {
                    MessageEvent e;
                    while ((e = this.writeBuffer.poll()) != null) {
                        Channels.fireMessageReceived(pairedChannel, e.getMessage());
                        e.getFuture().setSuccess();
                        Channels.fireWriteComplete(this, 1L);
                    }
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.delivering.set(false);
                    throw throwable;
                }
                this.delivering.set(false);
                {
                }
            }
        } else {
            MessageEvent e;
            Exception cause = this.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
            while ((e = this.writeBuffer.poll()) != null) {
                e.getFuture().setFailure(cause);
                Channels.fireExceptionCaught(this, (Throwable)cause);
            }
        }
    }
}

