/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobDetailsHeaders;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCompletedCheckpointStorageLocation;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.test.util.SuccessException;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;

public class TestUtils {
    public static void tryExecute(StreamExecutionEnvironment see, String name) throws Exception {
        block5: {
            JobClient jobClient = null;
            try {
                StreamGraph graph = see.getStreamGraph();
                graph.setJobName(name);
                jobClient = see.executeAsync(graph);
                jobClient.getJobExecutionResult().get();
            }
            catch (Throwable root) {
                Optional successAsCause;
                if (jobClient != null) {
                    try {
                        jobClient.cancel().get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((successAsCause = ExceptionUtils.findThrowable((Throwable)root, SuccessException.class)).isPresent()) break block5;
                root.printStackTrace();
                Assert.fail((String)("Test failed: " + root.getMessage()));
            }
        }
    }

    public static void submitJobAndWaitForResult(ClusterClient<?> client, JobGraph jobGraph, ClassLoader classLoader) throws Exception {
        ((JobResult)((CompletableFuture)client.submitJob((ExecutionPlan)jobGraph).thenCompose(arg_0 -> client.requestJobResult(arg_0))).get()).toJobExecutionResult(classLoader);
    }

    public static CheckpointMetadata loadCheckpointMetadata(String savepointPath) throws IOException {
        FsCompletedCheckpointStorageLocation location = AbstractFsCheckpointStorageAccess.resolveCheckpointPointer((String)savepointPath);
        try (DataInputStream stream = new DataInputStream((InputStream)location.getMetadataHandle().openInputStream());){
            CheckpointMetadata checkpointMetadata = Checkpoints.loadCheckpointMetadata((DataInputStream)stream, (ClassLoader)Thread.currentThread().getContextClassLoader(), (String)savepointPath);
            return checkpointMetadata;
        }
    }

    @Deprecated
    public static File getMostRecentCompletedCheckpoint(File checkpointDir) throws IOException {
        return TestUtils.getMostRecentCompletedCheckpointMaybe(checkpointDir).orElseThrow(() -> new IllegalStateException("Cannot generate checkpoint"));
    }

    @Deprecated
    public static Optional<File> getMostRecentCompletedCheckpointMaybe(File checkpointDir) throws IOException {
        return Files.find(checkpointDir.toPath(), 2, TestUtils::isCompletedCheckpoint, new FileVisitOption[0]).max(Comparator.comparing(Path::toString)).map(Path::toFile);
    }

    private static boolean isCompletedCheckpoint(Path path, BasicFileAttributes attr) {
        return attr.isDirectory() && path.getFileName().toString().startsWith("chk-") && TestUtils.hasMetadata(path);
    }

    private static boolean hasMetadata(Path file) {
        try {
            return Files.find(file.toAbsolutePath(), 1, (path, attrs) -> path.getFileName().toString().equals("_metadata"), new FileVisitOption[0]).findAny().isPresent();
        }
        catch (UncheckedIOException uncheckedIOException) {
            if (ExceptionUtils.findThrowable((Throwable)uncheckedIOException, NoSuchFileException.class).isPresent()) {
                return false;
            }
            throw uncheckedIOException;
        }
        catch (IOException ioException) {
            ExceptionUtils.rethrow((Throwable)ioException);
            return false;
        }
    }

    @Deprecated
    public static void waitUntilExternalizedCheckpointCreated(File checkpointDir) throws InterruptedException, IOException {
        Optional<File> externalizedCheckpoint;
        do {
            Thread.sleep(50L);
        } while (!(externalizedCheckpoint = TestUtils.getMostRecentCompletedCheckpointMaybe(checkpointDir)).isPresent());
    }

    public static void waitUntilJobCanceled(JobID jobId, ClusterClient<?> client) throws ExecutionException, InterruptedException {
        while (client.getJobStatus(jobId).get() != JobStatus.CANCELED) {
            Thread.sleep(50L);
        }
    }

    public static void waitUntilAllTasksAreRunning(RestClusterClient<?> restClusterClient, JobID jobId) throws Exception {
        JobDetailsHeaders detailsHeaders = JobDetailsHeaders.getInstance();
        JobMessageParameters params = detailsHeaders.getUnresolvedMessageParameters();
        params.jobPathParameter.resolve((Object)jobId);
        CommonTestUtils.waitUntilCondition(() -> (Boolean)((CompletableFuture)restClusterClient.sendRequest((MessageHeaders)detailsHeaders, (MessageParameters)params, (RequestBody)EmptyRequestBody.getInstance()).thenApply(detailsInfo -> TestUtils.allVerticesRunning(detailsInfo.getJobVerticesPerState()))).get());
    }

    public static void waitUntil(Supplier<Boolean> condition, String message) throws InterruptedException, TimeoutException {
        TestUtils.waitUntil(condition, Duration.ofSeconds(5L), message);
    }

    public static void waitUntil(Supplier<Boolean> condition, Duration timeout, String message) throws InterruptedException, TimeoutException {
        long startTime = System.currentTimeMillis();
        while (!condition.get().booleanValue() && System.currentTimeMillis() < startTime + timeout.toMillis()) {
            Thread.sleep(1L);
        }
        if (!condition.get().booleanValue()) {
            throw new TimeoutException(message);
        }
    }

    private static boolean allVerticesRunning(Map<ExecutionState, Integer> states) {
        return states.entrySet().stream().allMatch(entry -> {
            if (entry.getKey() == ExecutionState.RUNNING) {
                return (Integer)entry.getValue() > 0;
            }
            return (Integer)entry.getValue() == 0;
        });
    }
}

