/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.junit5.InjectClusterClient;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.util.FileUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestBase.class);
    private static final int DEFAULT_PARALLELISM = 4;
    @RegisterExtension
    public static final MiniClusterExtension MINI_CLUSTER_EXTENSION = new MiniClusterExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).build());
    @TempDir
    protected File temporaryFolder;

    @AfterEach
    public final void cleanupRunningJobs(@InjectClusterClient MiniClusterClient clusterClient) throws Exception {
        if (!MINI_CLUSTER_EXTENSION.isRunning()) {
            LOG.warn("Mini cluster is not running after the test!");
            return;
        }
        for (JobStatusMessage path : (Collection)clusterClient.listJobs().get()) {
            if (path.getJobState().isTerminalState()) continue;
            try {
                clusterClient.cancel(path.getJobId()).get();
            }
            catch (Exception exception) {}
        }
    }

    public String getTempDirPath(String dirName) throws IOException {
        File f = this.createAndRegisterTempFile(dirName);
        return f.toURI().toString();
    }

    public String getTempFilePath(String fileName) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        return f.toURI().toString();
    }

    public String createTempFile(String fileName, String contents) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        f.createNewFile();
        FileUtils.writeFileUtf8((File)f, (String)contents);
        return f.toURI().toString();
    }

    public File createAndRegisterTempFile(String fileName) throws IOException {
        return new File(this.temporaryFolder, fileName);
    }
}

