/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.test.parameters.ParameterProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    private static final ParameterProperty<Path> PROJECT_ROOT_DIRECTORY = new ParameterProperty<Path>("rootDir", x$0 -> Paths.get(x$0, new String[0]));
    private static final ParameterProperty<Path> DISTRIBUTION_DIRECTORY = new ParameterProperty<Path>("distDir", x$0 -> Paths.get(x$0, new String[0]));

    public static void replace(Path file, Pattern pattern, Function<Matcher, String> replacer) throws IOException {
        List<String> fileLines = Files.readAllLines(file);
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(file, StandardOpenOption.TRUNCATE_EXISTING), StandardCharsets.UTF_8.name()));){
            for (String fileLine : fileLines) {
                Matcher matcher = pattern.matcher(fileLine);
                if (matcher.matches()) {
                    String replacement = replacer.apply(matcher);
                    pw.println(replacement);
                    continue;
                }
                pw.println(fileLine);
            }
        }
    }

    public static Path findFlinkDist() {
        Optional<Path> distributionDirectory = DISTRIBUTION_DIRECTORY.get();
        if (!distributionDirectory.isPresent()) {
            Path projectRootPath;
            LOG.debug("The '{}' property was not set; attempting to automatically determine distribution location.", (Object)DISTRIBUTION_DIRECTORY.getPropertyName());
            Optional<Path> projectRoot = PROJECT_ROOT_DIRECTORY.get();
            if (projectRoot.isPresent()) {
                projectRootPath = projectRoot.get();
            } else {
                Optional<Path> projectRootDirectory = FileUtils.findProjectRootDirectory(Paths.get("", new String[0]).toAbsolutePath());
                if (projectRootDirectory.isPresent()) {
                    projectRootPath = projectRootDirectory.get();
                } else {
                    throw new IllegalArgumentException("The 'distDir' property was not set and the flink-dist module could not be found automatically. Please point the 'distDir' property to the directory containing distribution; you can set it when running maven via -DdistDir=<path> .");
                }
            }
            Optional<Path> distribution = FileUtils.findDistribution(projectRootPath);
            if (!distribution.isPresent()) {
                throw new IllegalArgumentException("The 'distDir' property was not set and a distribution could not be found automatically. Please point the 'distDir' property to the directory containing distribution; you can set it when running maven via -DdistDir=<path> .");
            }
            distributionDirectory = distribution;
        }
        return distributionDirectory.get();
    }

    private static Optional<Path> findProjectRootDirectory(Path currentDirectory) {
        do {
            if (!Files.exists(currentDirectory.resolve("flink-dist"), new LinkOption[0])) continue;
            return Optional.of(currentDirectory);
        } while ((currentDirectory = currentDirectory.getParent()).getFileName().toString().startsWith("flink"));
        return Optional.empty();
    }

    private static Optional<Path> findDistribution(Path projectRootDirectory) {
        Path distTargetDirectory = projectRootDirectory.resolve("flink-dist").resolve("target");
        try {
            Collection paths = org.apache.flink.util.FileUtils.listFilesInDirectory((Path)distTargetDirectory, FileUtils::isDistribution);
            if (paths.size() == 0) {
                return Optional.empty();
            }
            if (paths.size() > 1) {
                LOG.warn("Detected multiple distributions under flink-dist/target. It is recommended to explicitly select the distribution by setting the '{}}' property.", (Object)DISTRIBUTION_DIRECTORY.getPropertyName());
            }
            return Optional.of(((Path)paths.iterator().next()).getParent().getParent());
        }
        catch (IOException e) {
            LOG.error("Error while searching for distribution.", (Throwable)e);
            return Optional.empty();
        }
    }

    private static boolean isDistribution(Path path) {
        return path.getFileName().toString().contains("flink-dist") && path.getParent().getFileName().toString().equals("lib");
    }
}

