/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.CollectionTestEnvironment;
import org.apache.flink.test.util.TestEnvironment;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public abstract class JavaProgramTestBase
extends AbstractTestBase {
    private JobExecutionResult latestExecutionResult;
    private int numberOfTestRepetitions = 1;
    private boolean isCollectionExecution;

    public void setNumberOfTestRepetitions(int numberOfTestRepetitions) {
        this.numberOfTestRepetitions = numberOfTestRepetitions;
    }

    public int getParallelism() {
        return this.isCollectionExecution ? 1 : MINI_CLUSTER_EXTENSION.getNumberSlots();
    }

    public JobExecutionResult getLatestExecutionResult() {
        return this.latestExecutionResult;
    }

    public boolean isCollectionExecution() {
        return this.isCollectionExecution;
    }

    protected abstract void testProgram() throws Exception;

    protected void preSubmit() throws Exception {
    }

    protected void postSubmit() throws Exception {
    }

    protected boolean skipCollectionExecution() {
        return false;
    }

    @Test
    public void testJobWithObjectReuse() throws Exception {
        this.isCollectionExecution = false;
        this.preSubmit();
        TestEnvironment env = MINI_CLUSTER_EXTENSION.getTestEnvironment();
        env.getConfig().enableObjectReuse();
        this.executeProgramMultipleTimes(env);
    }

    private void executeProgramMultipleTimes(ExecutionEnvironment env) throws Exception {
        for (int i = 0; i < this.numberOfTestRepetitions; ++i) {
            try {
                this.testProgram();
                this.latestExecutionResult = env.getLastJobExecutionResult();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                AssertionsForClassTypes.fail((String)("Error while calling the test program: " + e.getMessage()));
            }
            ((ObjectAssert)Assertions.assertThat((Object)this.latestExecutionResult).as("The test program never triggered an execution.", new Object[0])).isNotNull();
        }
        this.postSubmit();
    }

    @Test
    public void testJobWithoutObjectReuse() throws Exception {
        this.isCollectionExecution = false;
        this.preSubmit();
        TestEnvironment env = MINI_CLUSTER_EXTENSION.getTestEnvironment();
        env.getConfig().disableObjectReuse();
        this.executeProgramMultipleTimes(env);
    }

    @Test
    public void testJobCollectionExecution() throws Exception {
        if (this.skipCollectionExecution()) {
            return;
        }
        this.isCollectionExecution = true;
        this.preSubmit();
        CollectionTestEnvironment env = new CollectionTestEnvironment();
        env.setAsContext();
        try {
            this.testProgram();
            this.latestExecutionResult = env.getLastJobExecutionResult();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            AssertionsForClassTypes.fail((String)("Error while calling the test program: " + e.getMessage()));
        }
        finally {
            MINI_CLUSTER_EXTENSION.getTestEnvironment().setAsContext();
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.latestExecutionResult).as("The test program never triggered an execution.", new Object[0])).isNotNull();
        this.postSubmit();
    }
}

