/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.upserttest.table;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.upserttest.table.UpsertTestConnectorOptions;
import org.apache.flink.connector.upserttest.table.UpsertTestDynamicTableSink;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;

@Internal
public class UpsertTestDynamicTableSinkFactory
implements DynamicTableSinkFactory {
    public static final String IDENTIFIER = "upsert-files";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        EncodingFormat keyEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, UpsertTestConnectorOptions.KEY_FORMAT_OPTION);
        EncodingFormat valueEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, UpsertTestConnectorOptions.VALUE_FORMAT_OPTION);
        ReadableConfig tableOptions = helper.getOptions();
        String outputFilePath = (String)tableOptions.get(UpsertTestConnectorOptions.OUTPUT_FILEPATH_OPTION);
        return new UpsertTestDynamicTableSink(context.getPhysicalRowDataType(), (EncodingFormat<SerializationSchema<RowData>>)keyEncodingFormat, (EncodingFormat<SerializationSchema<RowData>>)valueEncodingFormat, outputFilePath);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(UpsertTestConnectorOptions.OUTPUT_FILEPATH_OPTION);
        options.add(UpsertTestConnectorOptions.KEY_FORMAT_OPTION);
        options.add(UpsertTestConnectorOptions.VALUE_FORMAT_OPTION);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }
}

