/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.oss;

import javax.annotation.Nullable;
import org.junit.Assume;

public class OSSTestCredentials {
    @Nullable
    private static final String ENDPOINT = System.getenv("ARTIFACTS_OSS_ENDPOINT");
    @Nullable
    private static final String BUCKET = System.getenv("ARTIFACTS_OSS_BUCKET");
    @Nullable
    private static final String ACCESS_KEY = System.getenv("ARTIFACTS_OSS_ACCESS_KEY");
    @Nullable
    private static final String SECRET_KEY = System.getenv("ARTIFACTS_OSS_SECRET_KEY");

    public static boolean credentialsAvailable() {
        return ENDPOINT != null && BUCKET != null && ACCESS_KEY != null && SECRET_KEY != null;
    }

    public static void assumeCredentialsAvailable() {
        Assume.assumeTrue((String)"No OSS credentials available in this test's environment", (boolean)OSSTestCredentials.credentialsAvailable());
    }

    public static String getOSSEndpoint() {
        if (ENDPOINT != null) {
            return ENDPOINT;
        }
        throw new IllegalStateException("OSS endpoint is not available");
    }

    public static String getOSSAccessKey() {
        if (ACCESS_KEY != null) {
            return ACCESS_KEY;
        }
        throw new IllegalStateException("OSS access key is not available");
    }

    public static String getOSSSecretKey() {
        if (SECRET_KEY != null) {
            return SECRET_KEY;
        }
        throw new IllegalStateException("OSS secret key is not available");
    }

    public static String getTestBucketUri() {
        return OSSTestCredentials.getTestBucketUriWithScheme("oss");
    }

    public static String getTestBucketUriWithScheme(String scheme) {
        if (BUCKET != null) {
            return scheme + "://" + BUCKET + "/";
        }
        throw new IllegalStateException("OSS test bucket is not available");
    }
}

