/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mock;

import java.lang.reflect.Field;

public class Whitebox {
    public static <T> T getInternalState(Object target, String field) {
        Class<?> c = target.getClass();
        try {
            Field f = Whitebox.getFieldFromHierarchy(c, field);
            f.setAccessible(true);
            return (T)f.get(target);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set internal state on a private field. Please report to mockito mailing list.", e);
        }
    }

    public static void setInternalState(Object target, String field, Object value) {
        Class<?> c = target.getClass();
        try {
            Field f = Whitebox.getFieldFromHierarchy(c, field);
            f.setAccessible(true);
            f.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set internal state on a private field. Please report to mockito mailing list.", e);
        }
    }

    private static Field getFieldFromHierarchy(Class<?> clazz, String field) {
        Field f = Whitebox.getField(clazz, field);
        while (f == null && clazz != Object.class) {
            clazz = clazz.getSuperclass();
            f = Whitebox.getField(clazz, field);
        }
        if (f == null) {
            throw new RuntimeException("You want me to set value to this field: '" + field + "' on this class: '" + clazz.getSimpleName() + "' but this field is not declared withing hierarchy of this class!");
        }
        return f;
    }

    private static Field getField(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

