/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util.source;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.test.util.source.TestSourceReader;
import org.apache.flink.test.util.source.TestSplit;
import org.apache.flink.test.util.source.TestSplitEnumerator;

@PublicEvolving
public abstract class AbstractTestSourceBase<T, EnumChkptState>
implements Source<T, TestSplit, EnumChkptState> {
    private static final long serialVersionUID = 1L;

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SourceReader<T, TestSplit> createReader(SourceReaderContext readerContext) {
        return new TestSourceReader<T>(readerContext){

            @Override
            public InputStatus pollNext(ReaderOutput<T> output) {
                return InputStatus.END_OF_INPUT;
            }
        };
    }

    public SplitEnumerator<TestSplit, EnumChkptState> createEnumerator(SplitEnumeratorContext<TestSplit> enumContext) {
        return new TestSplitEnumerator<Object>(enumContext, null);
    }

    public SplitEnumerator<TestSplit, EnumChkptState> restoreEnumerator(SplitEnumeratorContext<TestSplit> enumContext, EnumChkptState checkpoint) {
        return new TestSplitEnumerator<EnumChkptState>(enumContext, checkpoint);
    }

    public SimpleVersionedSerializer<TestSplit> getSplitSerializer() {
        return TestSplit.SERIALIZER;
    }

    public abstract SimpleVersionedSerializer<EnumChkptState> getEnumeratorCheckpointSerializer();
}

