/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.filesystem.FileSystemConnectorOptions;
import org.apache.flink.table.filesystem.stream.PartitionCommitPredicate;

public class ProcTimeCommitPredicate
implements PartitionCommitPredicate {
    private final long commitDelay;

    public ProcTimeCommitPredicate(Configuration conf) {
        this.commitDelay = ((Duration)conf.get(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_DELAY)).toMillis();
    }

    @Override
    public boolean isPartitionCommittable(PartitionCommitPredicate.PredicateContext predicateContext) {
        long currentProcTime = predicateContext.currentProcTime();
        return this.commitDelay == 0L || currentProcTime > predicateContext.createProcTime() + this.commitDelay;
    }
}

