/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.TypedSetters;
import org.apache.flink.types.RowKind;

public final class UpdatableRowData
implements RowData,
TypedSetters {
    private RowData row;
    private final Object[] fields;
    private final boolean[] updated;

    public UpdatableRowData(RowData row, int arity) {
        this.row = row;
        this.fields = new Object[arity];
        this.updated = new boolean[arity];
    }

    public RowData getRow() {
        return this.row;
    }

    public int getArity() {
        return this.fields.length;
    }

    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    public boolean isNullAt(int pos) {
        return this.updated[pos] ? this.fields[pos] == null : this.row.isNullAt(pos);
    }

    public boolean getBoolean(int pos) {
        return this.updated[pos] ? ((Boolean)this.fields[pos]).booleanValue() : this.row.getBoolean(pos);
    }

    public byte getByte(int pos) {
        return this.updated[pos] ? ((Byte)this.fields[pos]).byteValue() : this.row.getByte(pos);
    }

    public short getShort(int pos) {
        return this.updated[pos] ? ((Short)this.fields[pos]).shortValue() : this.row.getShort(pos);
    }

    public int getInt(int pos) {
        return this.updated[pos] ? ((Integer)this.fields[pos]).intValue() : this.row.getInt(pos);
    }

    public long getLong(int pos) {
        return this.updated[pos] ? ((Long)this.fields[pos]).longValue() : this.row.getLong(pos);
    }

    public float getFloat(int pos) {
        return this.updated[pos] ? ((Float)this.fields[pos]).floatValue() : this.row.getFloat(pos);
    }

    public double getDouble(int pos) {
        return this.updated[pos] ? ((Double)this.fields[pos]).doubleValue() : this.row.getDouble(pos);
    }

    public byte[] getBinary(int pos) {
        return this.updated[pos] ? (byte[])this.fields[pos] : this.row.getBinary(pos);
    }

    public StringData getString(int pos) {
        return this.updated[pos] ? (StringData)this.fields[pos] : this.row.getString(pos);
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.updated[pos] ? (DecimalData)this.fields[pos] : this.row.getDecimal(pos, precision, scale);
    }

    public TimestampData getTimestamp(int pos, int precision) {
        return this.updated[pos] ? (TimestampData)this.fields[pos] : this.row.getTimestamp(pos, precision);
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        return this.updated[pos] ? (RawValueData)this.fields[pos] : this.row.getRawValue(pos);
    }

    public RowData getRow(int pos, int numFields) {
        return this.updated[pos] ? (RowData)this.fields[pos] : this.row.getRow(pos, numFields);
    }

    public ArrayData getArray(int pos) {
        return this.updated[pos] ? (ArrayData)this.fields[pos] : this.row.getArray(pos);
    }

    public MapData getMap(int pos) {
        return this.updated[pos] ? (MapData)this.fields[pos] : this.row.getMap(pos);
    }

    public void setNullAt(int pos) {
        this.setField(pos, null);
    }

    public void setBoolean(int pos, boolean value) {
        this.setField(pos, value);
    }

    public void setByte(int pos, byte value) {
        this.setField(pos, value);
    }

    public void setShort(int pos, short value) {
        this.setField(pos, value);
    }

    public void setInt(int pos, int value) {
        this.setField(pos, value);
    }

    public void setLong(int pos, long value) {
        this.setField(pos, value);
    }

    public void setFloat(int pos, float value) {
        this.setField(pos, Float.valueOf(value));
    }

    public void setDouble(int pos, double value) {
        this.setField(pos, value);
    }

    public void setDecimal(int pos, DecimalData value, int precision) {
        this.setField(pos, value);
    }

    public void setTimestamp(int pos, TimestampData value, int precision) {
        this.setField(pos, value);
    }

    public void setField(int pos, Object value) {
        this.updated[pos] = true;
        this.fields[pos] = value;
    }
}

