/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.sequencedmultisetstate.linked;

import java.util.Objects;
import org.apache.flink.util.Preconditions;

class RowSqnInfo {
    public final long firstSqn;
    public final long lastSqn;

    public RowSqnInfo(long firstSqn, long lastSqn) {
        Preconditions.checkArgument((firstSqn <= lastSqn ? 1 : 0) != 0);
        this.firstSqn = firstSqn;
        this.lastSqn = lastSqn;
    }

    public static RowSqnInfo ofSingle(long sqn) {
        return RowSqnInfo.of(sqn, sqn);
    }

    public static RowSqnInfo of(long first, long last) {
        return new RowSqnInfo(first, last);
    }

    public String toString() {
        return "RowSqnInfo{firstSqn=" + this.firstSqn + ", lastSqn=" + this.lastSqn + "}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof RowSqnInfo)) {
            return false;
        }
        RowSqnInfo that = (RowSqnInfo)o;
        return this.firstSqn == that.firstSqn && this.lastSqn == that.lastSqn;
    }

    public int hashCode() {
        return Objects.hash(this.firstSqn, this.lastSqn);
    }

    public RowSqnInfo withFirstSqn(long firstSqn) {
        return RowSqnInfo.of(firstSqn, this.lastSqn);
    }
}

