/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.shaded.guava33.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava33.com.google.common.cache.CacheBuilder;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.TopNBuffer;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppendOnlyTopNHelper
extends AbstractTopNFunction.AbstractTopNHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AppendOnlyTopNHelper.class);
    private final Cache<RowData, TopNBuffer> kvSortedMap;
    private final long topNSize;

    public AppendOnlyTopNHelper(AbstractTopNFunction topNFunction, long cacheSize, long topNSize) {
        super(topNFunction);
        this.topNSize = topNSize;
        int lruCacheSize = Math.max(1, (int)(cacheSize / topNSize));
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.ttlConfig.isEnabled()) {
            cacheBuilder.expireAfterWrite(this.ttlConfig.getTimeToLive().toMillis(), TimeUnit.MILLISECONDS);
        }
        this.kvSortedMap = cacheBuilder.maximumSize((long)lruCacheSize).build();
        LOG.info("Top{} operator is using LRU caches key-size: {}", (Object)topNSize, (Object)lruCacheSize);
    }

    public void registerMetric() {
        this.registerMetric(this.kvSortedMap.size() * this.topNSize);
    }

    @Nullable
    public TopNBuffer getTopNBufferFromCache(RowData currentKey) {
        return (TopNBuffer)this.kvSortedMap.getIfPresent((Object)currentKey);
    }

    public void saveTopNBufferToCache(RowData currentKey, TopNBuffer topNBuffer) {
        this.kvSortedMap.put((Object)currentKey, (Object)topNBuffer);
    }

    public void processElementWithRowNumber(TopNBuffer buffer, RowData sortKey, RowData input, long rankEnd, Collector<RowData> out) throws Exception {
        Iterator<Map.Entry<RowData, Collection<RowData>>> iterator = buffer.entrySet().iterator();
        long currentRank = 0L;
        boolean findsSortKey = false;
        RowData currentRow = null;
        while (iterator.hasNext() && this.isInRankEnd(currentRank, rankEnd)) {
            Map.Entry<RowData, Collection<RowData>> entry = iterator.next();
            Collection<RowData> records = entry.getValue();
            if (!findsSortKey && entry.getKey().equals(sortKey)) {
                currentRank += (long)records.size();
                currentRow = input;
                findsSortKey = true;
                continue;
            }
            if (findsSortKey) {
                Iterator<RowData> recordsIter = records.iterator();
                while (recordsIter.hasNext() && this.isInRankEnd(currentRank, rankEnd)) {
                    RowData prevRow = recordsIter.next();
                    this.collectUpdateBefore(out, prevRow, currentRank, rankEnd);
                    this.collectUpdateAfter(out, currentRow, currentRank, rankEnd);
                    currentRow = prevRow;
                    ++currentRank;
                }
                continue;
            }
            currentRank += (long)records.size();
        }
        if (this.isInRankEnd(currentRank, rankEnd)) {
            this.collectInsert(out, currentRow, currentRank, rankEnd);
        }
        ArrayList<RowData> toDeleteSortKeys = new ArrayList<RowData>();
        while (iterator.hasNext()) {
            Map.Entry<RowData, Collection<RowData>> entry = iterator.next();
            RowData key = entry.getKey();
            this.removeFromState(key);
            toDeleteSortKeys.add(key);
        }
        for (RowData toDeleteKey : toDeleteSortKeys) {
            buffer.removeAll(toDeleteKey);
        }
    }

    public void processElementWithoutRowNumber(TopNBuffer buffer, RowData input, long rankEnd, Collector<RowData> out) throws Exception {
        if ((long)buffer.getCurrentTopNum() > rankEnd) {
            Map.Entry<RowData, Collection<RowData>> lastEntry = buffer.lastEntry();
            RowData lastKey = lastEntry.getKey();
            Collection<RowData> lastList = lastEntry.getValue();
            RowData lastElement = buffer.lastElement();
            int size = lastList.size();
            if (size <= 1) {
                buffer.removeAll(lastKey);
                this.removeFromState(lastKey);
            } else {
                buffer.removeLast();
                this.updateState(lastKey, new ArrayList<RowData>(lastList));
            }
            if (size == 0 || input.equals(lastElement)) {
                return;
            }
            this.collectDelete(out, lastElement);
        }
        this.collectInsert(out, input);
    }

    protected abstract void removeFromState(RowData var1) throws Exception;

    protected abstract void updateState(RowData var1, List<RowData> var2) throws Exception;
}

