/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.operators.join.stream.state.MultiJoinStateView;
import org.apache.flink.table.runtime.operators.join.stream.utils.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.IterableIterator;
import org.apache.flink.util.Preconditions;

public final class MultiJoinStateViews {
    public static MultiJoinStateView create(RuntimeContext ctx, String stateName, JoinInputSideSpec inputSideSpec, @Nullable RowType joinKeyType, RowType recordType, long retentionTime) {
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig(retentionTime);
        if (inputSideSpec.hasUniqueKey()) {
            if (inputSideSpec.joinKeyContainsUniqueKey() && joinKeyType != null) {
                return new JoinKeyContainsUniqueKey(ctx, stateName, joinKeyType, recordType, ttlConfig);
            }
            return new InputSideHasUniqueKey(ctx, stateName, joinKeyType, recordType, inputSideSpec.getUniqueKeyType(), inputSideSpec.getUniqueKeySelector(), ttlConfig);
        }
        return new InputSideHasNoUniqueKey(ctx, stateName, joinKeyType, recordType, ttlConfig);
    }

    private static <K, V> MapStateDescriptor<K, V> createStateDescriptor(String stateName, TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo, StateTtlConfig ttlConfig) {
        MapStateDescriptor descriptor = new MapStateDescriptor(stateName, keyTypeInfo, valueTypeInfo);
        if (ttlConfig.isEnabled()) {
            descriptor.enableTimeToLive(ttlConfig);
        }
        return descriptor;
    }

    private static final class InputSideHasNoUniqueKey
    implements MultiJoinStateView {
        private final MapState<RowData, Integer> recordState;
        private RowDataSerializer joinKeySerializer;
        private int joinKeyFieldCount;
        private final int recordFieldCount;
        @Nullable
        private final RowType joinKeyType;

        private InputSideHasNoUniqueKey(RuntimeContext ctx, String stateName, @Nullable RowType joinKeyType, RowType recordType, StateTtlConfig ttlConfig) {
            InternalTypeInfo<RowData> keyStateType;
            this.joinKeyType = joinKeyType;
            this.recordFieldCount = recordType.getFieldCount();
            if (this.joinKeyType == null) {
                keyStateType = InternalTypeInfo.of(recordType);
            } else {
                this.joinKeySerializer = new RowDataSerializer(this.joinKeyType);
                this.joinKeyFieldCount = this.joinKeyType.getFieldCount();
                RowType keyRowType = RowType.of((LogicalType[])new LogicalType[]{this.joinKeyType, recordType});
                keyStateType = InternalTypeInfo.of(keyRowType);
            }
            MapStateDescriptor recordStateDesc = MultiJoinStateViews.createStateDescriptor(stateName, keyStateType, Types.INT, ttlConfig);
            this.recordState = ctx.getMapState(recordStateDesc);
        }

        private boolean joinKeysEqual(RowData joinKeyToLookup, RowData currentJoinKeyInState) {
            BinaryRowData binaryJoinKey = this.joinKeySerializer.toBinaryRow(joinKeyToLookup);
            BinaryRowData binaryCurrJoinKey = this.joinKeySerializer.toBinaryRow(currentJoinKeyInState);
            return binaryJoinKey.equals((Object)binaryCurrJoinKey);
        }

        private RowData getStateKey(@Nullable RowData joinKey, RowData record) {
            if (joinKey == null) {
                return record;
            }
            GenericRowData compositeKey = new GenericRowData(2);
            compositeKey.setField(0, (Object)joinKey);
            compositeKey.setField(1, (Object)record);
            return compositeKey;
        }

        @Override
        public void addRecord(@Nullable RowData joinKey, RowData record) throws Exception {
            RowKind originalKind = record.getRowKind();
            record.setRowKind(RowKind.INSERT);
            RowData stateKey = this.getStateKey(joinKey, record);
            Integer currentCount = (Integer)this.recordState.get((Object)stateKey);
            if (currentCount == null) {
                currentCount = 0;
            }
            this.recordState.put((Object)stateKey, (Object)(currentCount + 1));
            record.setRowKind(originalKind);
        }

        @Override
        public void retractRecord(@Nullable RowData joinKey, RowData record) throws Exception {
            RowKind originalKind = record.getRowKind();
            record.setRowKind(RowKind.INSERT);
            RowData stateKey = this.getStateKey(joinKey, record);
            Integer currentCount = (Integer)this.recordState.get((Object)stateKey);
            if (currentCount != null) {
                if (currentCount > 1) {
                    this.recordState.put((Object)stateKey, (Object)(currentCount - 1));
                } else {
                    this.recordState.remove((Object)stateKey);
                }
            }
            record.setRowKind(originalKind);
        }

        @Override
        public Iterable<RowData> getRecords(final @Nullable RowData joinKey) throws Exception {
            if (joinKey == null) {
                final Iterator stateIterator = this.recordState.iterator();
                if (stateIterator == null) {
                    return Collections.emptyList();
                }
                return new IterableIterator<RowData>(){
                    private RowData currentRecordFromStateKey = null;
                    private int remainingTimes = 0;

                    public boolean hasNext() {
                        if (this.remainingTimes > 0) {
                            return true;
                        }
                        if (stateIterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)stateIterator.next();
                            this.currentRecordFromStateKey = (RowData)entry.getKey();
                            this.remainingTimes = (Integer)entry.getValue();
                            return this.remainingTimes > 0;
                        }
                        return false;
                    }

                    public RowData next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        --this.remainingTimes;
                        return this.currentRecordFromStateKey;
                    }

                    @Nonnull
                    public Iterator<RowData> iterator() {
                        return this;
                    }
                };
            }
            final Iterator stateIterator = this.recordState.iterator();
            if (stateIterator == null) {
                return Collections.emptyList();
            }
            return new IterableIterator<RowData>(){
                private RowData currentRecord = null;
                private int remainingTimes = 0;

                public boolean hasNext() {
                    if (this.remainingTimes > 0) {
                        return true;
                    }
                    while (stateIterator.hasNext()) {
                        Map.Entry currentEntry = (Map.Entry)stateIterator.next();
                        RowData compositeKey = (RowData)currentEntry.getKey();
                        RowData currentJoinKeyInState = compositeKey.getRow(0, joinKeyFieldCount);
                        if (!this.joinKeysEqual(joinKey, currentJoinKeyInState)) continue;
                        this.currentRecord = compositeKey.getRow(1, recordFieldCount);
                        this.remainingTimes = (Integer)currentEntry.getValue();
                        if (this.remainingTimes <= 0) continue;
                        return true;
                    }
                    return false;
                }

                public RowData next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    --this.remainingTimes;
                    return this.currentRecord;
                }

                @Nonnull
                public Iterator<RowData> iterator() {
                    return this;
                }
            };
        }
    }

    private static final class InputSideHasUniqueKey
    implements MultiJoinStateView {
        private final MapState<RowData, RowData> recordState;
        private final KeySelector<RowData, RowData> uniqueKeySelector;
        private RowDataSerializer joinKeySerializer;
        private int joinKeyFieldCount = 0;

        private InputSideHasUniqueKey(RuntimeContext ctx, String stateName, @Nullable RowType joinKeyType, RowType recordType, InternalTypeInfo<RowData> uniqueKeyType, KeySelector<RowData, RowData> uniqueKeySelector, StateTtlConfig ttlConfig) {
            InternalTypeInfo<RowData> keyStateType;
            Preconditions.checkNotNull(uniqueKeyType);
            Preconditions.checkNotNull(uniqueKeySelector);
            this.uniqueKeySelector = uniqueKeySelector;
            if (joinKeyType == null) {
                keyStateType = uniqueKeyType;
            } else {
                this.joinKeySerializer = new RowDataSerializer(joinKeyType);
                this.joinKeyFieldCount = joinKeyType.getFieldCount();
                RowType keyRowType = RowType.of((LogicalType[])new LogicalType[]{joinKeyType, uniqueKeyType.toRowType()});
                keyStateType = InternalTypeInfo.of(keyRowType);
            }
            MapStateDescriptor<RowData, RowData> recordStateDesc = MultiJoinStateViews.createStateDescriptor(stateName, keyStateType, InternalTypeInfo.of(recordType), ttlConfig);
            this.recordState = ctx.getMapState(recordStateDesc);
        }

        private boolean joinKeysEqual(RowData joinKey, RowData currentJoinKeyInState) {
            BinaryRowData binaryJoinKey = this.joinKeySerializer.toBinaryRow(joinKey);
            BinaryRowData binaryCurrJoinKey = this.joinKeySerializer.toBinaryRow(currentJoinKeyInState);
            return binaryJoinKey.equals((Object)binaryCurrJoinKey);
        }

        private RowData getStateKey(RowData joinKey, RowData uniqueKey) {
            if (joinKey == null) {
                return uniqueKey;
            }
            GenericRowData compositeKey = new GenericRowData(2);
            compositeKey.setField(0, (Object)joinKey);
            compositeKey.setField(1, (Object)uniqueKey);
            return compositeKey;
        }

        @Override
        public void addRecord(@Nullable RowData joinKey, RowData record) throws Exception {
            RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
            RowData stateKey = this.getStateKey(joinKey, uniqueKey);
            this.recordState.put((Object)stateKey, (Object)record);
        }

        @Override
        public void retractRecord(@Nullable RowData joinKey, RowData record) throws Exception {
            RowData uniqueKey = (RowData)this.uniqueKeySelector.getKey((Object)record);
            RowData stateKey = this.getStateKey(joinKey, uniqueKey);
            this.recordState.remove((Object)stateKey);
        }

        @Override
        public Iterable<RowData> getRecords(final @Nullable RowData joinKey) throws Exception {
            if (joinKey == null || this.joinKeySerializer == null) {
                return this.recordState.values();
            }
            final Iterator stateIterator = this.recordState.iterator();
            if (stateIterator == null) {
                return Collections.emptyList();
            }
            return new IterableIterator<RowData>(){
                private RowData nextRecord = null;

                public boolean hasNext() {
                    if (this.nextRecord != null) {
                        return true;
                    }
                    while (stateIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)stateIterator.next();
                        RowData compositeKey = (RowData)entry.getKey();
                        RowData currentJoinKey = compositeKey.getRow(0, joinKeyFieldCount);
                        if (!this.joinKeysEqual(joinKey, currentJoinKey)) continue;
                        this.nextRecord = (RowData)entry.getValue();
                        return true;
                    }
                    return false;
                }

                public RowData next() {
                    if (this.hasNext()) {
                        RowData recordToReturn = this.nextRecord;
                        this.nextRecord = null;
                        return recordToReturn;
                    }
                    throw new NoSuchElementException();
                }

                @Nonnull
                public Iterator<RowData> iterator() {
                    return this;
                }
            };
        }
    }

    private static final class JoinKeyContainsUniqueKey
    implements MultiJoinStateView {
        private final MapState<RowData, RowData> recordState;
        private final List<RowData> reusedList;

        private JoinKeyContainsUniqueKey(RuntimeContext ctx, String stateName, RowType joinKeyType, RowType recordType, StateTtlConfig ttlConfig) {
            MapStateDescriptor<RowData, RowData> recordStateDesc = MultiJoinStateViews.createStateDescriptor(stateName, InternalTypeInfo.of(joinKeyType), InternalTypeInfo.of(recordType), ttlConfig);
            this.recordState = ctx.getMapState(recordStateDesc);
            this.reusedList = new ArrayList<RowData>(1);
        }

        @Override
        public void addRecord(RowData joinKey, RowData record) throws Exception {
            this.recordState.put((Object)joinKey, (Object)record);
        }

        @Override
        public void retractRecord(RowData joinKey, RowData record) throws Exception {
            this.recordState.remove((Object)joinKey);
        }

        @Override
        public Iterable<RowData> getRecords(RowData joinKey) throws Exception {
            this.reusedList.clear();
            RowData record = (RowData)this.recordState.get((Object)joinKey);
            if (record != null) {
                this.reusedList.add(record);
            }
            return this.reusedList;
        }
    }
}

