/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.sql.Timestamp;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.conversion.DataStructureConverter;

@Internal
public class LocalZonedTimestampTimestampConverter
implements DataStructureConverter<TimestampData, Timestamp> {
    private static final long serialVersionUID = 1L;
    private static final int NANOS_PER_MILL = 1000000;

    @Override
    public TimestampData toInternal(Timestamp external) {
        return TimestampData.fromEpochMillis((long)external.getTime(), (int)(external.getNanos() % 1000000));
    }

    @Override
    public Timestamp toExternal(TimestampData internal) {
        Timestamp ts = new Timestamp(internal.getMillisecond());
        ts.setNanos(ts.getNanos() + internal.getNanoOfMillisecond());
        return ts;
    }
}

