/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.runtime.util.EqualityAndHashcodeProvider;
import org.apache.flink.table.runtime.util.ObjectContainer;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayExceptFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;
    private final EqualityAndHashcodeProvider equalityAndHashcodeProvider;

    public ArrayExceptFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_EXCEPT, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType().toInternal();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.toInternal().getLogicalType());
        this.equalityAndHashcodeProvider = new EqualityAndHashcodeProvider(context, dataType);
    }

    public void open(FunctionContext context) throws Exception {
        this.equalityAndHashcodeProvider.open(context);
    }

    @Nullable
    public ArrayData eval(ArrayData arrayOne, ArrayData arrayTwo) {
        try {
            ObjectContainer objectContainer;
            Object element;
            int pos;
            if (arrayOne == null || arrayTwo == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            HashMap<ObjectContainer, Integer> map = new HashMap<ObjectContainer, Integer>();
            for (pos = 0; pos < arrayTwo.size(); ++pos) {
                element = this.elementGetter.getElementOrNull(arrayTwo, pos);
                objectContainer = this.createObjectContainer(element);
                map.merge(objectContainer, 1, (k, v) -> v + 1);
            }
            for (pos = 0; pos < arrayOne.size(); ++pos) {
                element = this.elementGetter.getElementOrNull(arrayOne, pos);
                objectContainer = this.createObjectContainer(element);
                if (map.containsKey(objectContainer)) {
                    map.compute(objectContainer, (k, v) -> v == null || v == 1 ? null : Integer.valueOf(v - 1));
                    continue;
                }
                list.add(element);
            }
            return new GenericArrayData(list.toArray());
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    private ObjectContainer createObjectContainer(Object element) {
        if (element == null) {
            return null;
        }
        return new ObjectContainer(element, this.equalityAndHashcodeProvider::equals, this.equalityAndHashcodeProvider::hashCode);
    }

    public void close() throws Exception {
        this.equalityAndHashcodeProvider.close();
    }
}

