/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.values;

import java.io.IOException;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.generated.GeneratedInput;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesInputFormat
extends GenericInputFormat<BaseRow>
implements NonParallelInput,
ResultTypeQueryable<BaseRow> {
    private static final Logger LOG = LoggerFactory.getLogger(ValuesInputFormat.class);
    private GeneratedInput<GenericInputFormat<BaseRow>> generatedInput;
    private final BaseRowTypeInfo returnType;
    private GenericInputFormat<BaseRow> format;

    public ValuesInputFormat(GeneratedInput<GenericInputFormat<BaseRow>> generatedInput, BaseRowTypeInfo returnType) {
        this.generatedInput = generatedInput;
        this.returnType = returnType;
    }

    public void open(GenericInputSplit split) {
        LOG.debug("Compiling GenericInputFormat: {} \n\n Code:\n{}", (Object)this.generatedInput.getClassName(), (Object)this.generatedInput.getCode());
        LOG.debug("Instantiating GenericInputFormat.");
        this.format = (GenericInputFormat)this.generatedInput.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.generatedInput = null;
    }

    public boolean reachedEnd() throws IOException {
        return this.format.reachedEnd();
    }

    public BaseRow nextRecord(BaseRow reuse) throws IOException {
        return (BaseRow)this.format.nextRecord((Object)reuse);
    }

    public BaseRowTypeInfo getProducedType() {
        return this.returnType;
    }
}

