/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRowsBoundedPrecedingFunction;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowTimeRangeBoundedPrecedingFunction<K>
extends KeyedProcessFunctionWithCleanupState<K, BaseRow, BaseRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RowTimeRowsBoundedPrecedingFunction.class);
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private transient JoinedRow output;
    private transient ValueState<Long> lastTriggeringTsState;
    private transient ValueState<BaseRow> accState;
    private transient MapState<Long, List<BaseRow>> inputState;
    private transient AggsHandleFunction function;

    public RowTimeRangeBoundedPrecedingFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, long precedingOffset, int rowTimeIdx) {
        super(minRetentionTime, maxRetentionTime);
        Preconditions.checkNotNull((Object)precedingOffset);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
    }

    public void open(Configuration parameters) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRow();
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Types.LONG);
        this.lastTriggeringTsState = this.getRuntimeContext().getState(lastTriggeringTsDescriptor);
        BaseRowTypeInfo accTypeInfo = new BaseRowTypeInfo(this.accTypes);
        ValueStateDescriptor accStateDesc = new ValueStateDescriptor("accState", (TypeInformation)accTypeInfo);
        this.accState = this.getRuntimeContext().getState(accStateDesc);
        BaseRowTypeInfo inputType = new BaseRowTypeInfo(this.inputFieldTypes);
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)inputType);
        MapStateDescriptor inputStateDesc = new MapStateDescriptor("inputState", Types.LONG, (TypeInformation)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(inputStateDesc);
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(BaseRow input, KeyedProcessFunction.Context ctx, Collector<BaseRow> out) throws Exception {
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = input.getLong(this.rowTimeIdx);
        Long lastTriggeringTs = (Long)this.lastTriggeringTsState.value();
        if (lastTriggeringTs == null) {
            lastTriggeringTs = 0L;
        }
        if (triggeringTs > lastTriggeringTs) {
            ArrayList<BaseRow> data = (ArrayList<BaseRow>)this.inputState.get((Object)triggeringTs);
            if (null != data) {
                data.add(input);
                this.inputState.put((Object)triggeringTs, data);
            } else {
                data = new ArrayList<BaseRow>();
                data.add(input);
                this.inputState.put((Object)triggeringTs, data);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) throws Exception {
        this.registerProcessingCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled) {
                Iterator keysIt = this.inputState.keys().iterator();
                Long lastProcessedTime = (Long)this.lastTriggeringTsState.value();
                if (lastProcessedTime == null) {
                    lastProcessedTime = 0L;
                }
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if ((Long)keysIt.next() <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState(new State[]{this.inputState, this.accState, this.lastTriggeringTsState});
                    this.function.cleanup();
                } else {
                    this.registerProcessingCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        List inputs = (List)this.inputState.get((Object)timestamp);
        if (null != inputs) {
            int dataListIndex = 0;
            BaseRow accumulators = (BaseRow)this.accState.value();
            if (null == accumulators) {
                accumulators = this.function.createAccumulators();
            }
            this.function.setAccumulators(accumulators);
            ArrayList<Long> retractTsList = new ArrayList<Long>();
            for (Long dataTs : this.inputState.keys()) {
                Long offset = timestamp - dataTs;
                if (offset <= this.precedingOffset) continue;
                List retractDataList = (List)this.inputState.get((Object)dataTs);
                if (retractDataList != null) {
                    for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                        BaseRow retractRow = (BaseRow)retractDataList.get(dataListIndex);
                        this.function.retract(retractRow);
                    }
                    retractTsList.add(dataTs);
                    continue;
                }
                LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                BaseRow curRow = (BaseRow)inputs.get(dataListIndex);
                this.function.accumulate(curRow);
            }
            BaseRow aggValue = this.function.getValue();
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                BaseRow curRow = (BaseRow)inputs.get(dataListIndex);
                this.output.replace(curRow, aggValue);
                out.collect((Object)this.output);
            }
            for (dataListIndex = 0; dataListIndex < retractTsList.size(); ++dataListIndex) {
                this.inputState.remove(retractTsList.get(dataListIndex));
            }
            accumulators = this.function.getAccumulators();
            this.accState.update((Object)accumulators);
        }
        this.lastTriggeringTsState.update((Object)timestamp);
        this.registerProcessingCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

