/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.temporal;

import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.operators.join.temporal.BaseTwoInputStreamOperatorWithStateRetention;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;

public class TemporalProcessTimeJoinOperator
extends BaseTwoInputStreamOperatorWithStateRetention {
    private static final long serialVersionUID = -5182289624027523612L;
    private final BaseRowTypeInfo rightType;
    private final GeneratedJoinCondition generatedJoinCondition;
    private transient ValueState<BaseRow> rightState;
    private transient JoinCondition joinCondition;
    private transient JoinedRow outRow;
    private transient TimestampedCollector<BaseRow> collector;

    public TemporalProcessTimeJoinOperator(BaseRowTypeInfo rightType, GeneratedJoinCondition generatedJoinCondition, long minRetentionTime, long maxRetentionTime) {
        super(minRetentionTime, maxRetentionTime);
        this.rightType = rightType;
        this.generatedJoinCondition = generatedJoinCondition;
    }

    @Override
    public void open() throws Exception {
        this.joinCondition = (JoinCondition)this.generatedJoinCondition.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext((Function)this.joinCondition, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction((Function)this.joinCondition, (Configuration)new Configuration());
        ValueStateDescriptor rightStateDesc = new ValueStateDescriptor("right", (TypeInformation)this.rightType);
        this.rightState = this.getRuntimeContext().getState(rightStateDesc);
        this.collector = new TimestampedCollector(this.output);
        this.outRow = new JoinedRow();
        super.processWatermark2(Watermark.MAX_WATERMARK);
    }

    public void processElement1(StreamRecord<BaseRow> element) throws Exception {
        BaseRow rightSideRow = (BaseRow)this.rightState.value();
        if (rightSideRow == null) {
            return;
        }
        BaseRow leftSideRow = (BaseRow)element.getValue();
        if (this.joinCondition.apply(leftSideRow, rightSideRow)) {
            this.outRow.setHeader(leftSideRow.getHeader());
            this.outRow.replace(leftSideRow, rightSideRow);
            this.collector.collect((Object)this.outRow);
        }
        this.registerProcessingCleanupTimer();
    }

    public void processElement2(StreamRecord<BaseRow> element) throws Exception {
        if (BaseRowUtil.isAccumulateMsg((BaseRow)element.getValue())) {
            this.rightState.update(element.getValue());
            this.registerProcessingCleanupTimer();
        } else {
            this.rightState.clear();
            this.cleanupLastTimer();
        }
    }

    public void close() throws Exception {
        FunctionUtils.closeFunction((Function)this.joinCondition);
    }

    @Override
    public void cleanupState(long time) {
        this.rightState.clear();
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) throws Exception {
    }
}

