/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.RecordCounter;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;

public class GroupAggFunction
extends KeyedProcessFunctionWithCleanupState<BaseRow, BaseRow, BaseRow> {
    private static final long serialVersionUID = -4767158666069797704L;
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final GeneratedRecordEqualiser genRecordEqualiser;
    private final LogicalType[] accTypes;
    private final RecordCounter recordCounter;
    private final boolean generateRetraction;
    private transient JoinedRow resultRow = null;
    private transient AggsHandleFunction function = null;
    private transient RecordEqualiser equaliser = null;
    private transient ValueState<BaseRow> accState = null;

    public GroupAggFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, LogicalType[] accTypes, int indexOfCountStar, boolean generateRetraction) {
        super(minRetentionTime, maxRetentionTime);
        this.genAggsHandler = genAggsHandler;
        this.genRecordEqualiser = genRecordEqualiser;
        this.accTypes = accTypes;
        this.recordCounter = RecordCounter.of(indexOfCountStar);
        this.generateRetraction = generateRetraction;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.equaliser = (RecordEqualiser)this.genRecordEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        BaseRowTypeInfo accTypeInfo = new BaseRowTypeInfo(this.accTypes);
        ValueStateDescriptor accDesc = new ValueStateDescriptor("accState", (TypeInformation)accTypeInfo);
        this.accState = this.getRuntimeContext().getState(accDesc);
        this.initCleanupTimeState("GroupAggregateCleanupTime");
        this.resultRow = new JoinedRow();
    }

    public void processElement(BaseRow input, KeyedProcessFunction.Context ctx, Collector<BaseRow> out) throws Exception {
        boolean firstRow;
        long currentTime = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime);
        BaseRow currentKey = (BaseRow)ctx.getCurrentKey();
        BaseRow accumulators = (BaseRow)this.accState.value();
        if (null == accumulators) {
            if (BaseRowUtil.isRetractMsg(input)) {
                return;
            }
            firstRow = true;
            accumulators = this.function.createAccumulators();
        } else {
            firstRow = false;
        }
        this.function.setAccumulators(accumulators);
        BaseRow prevAggValue = this.function.getValue();
        if (BaseRowUtil.isAccumulateMsg(input)) {
            this.function.accumulate(input);
        } else {
            this.function.retract(input);
        }
        BaseRow newAggValue = this.function.getValue();
        accumulators = this.function.getAccumulators();
        if (!this.recordCounter.recordCountIsZero(accumulators)) {
            this.accState.update((Object)accumulators);
            if (!firstRow) {
                if (!this.stateCleaningEnabled && this.equaliser.equalsWithoutHeader(prevAggValue, newAggValue)) {
                    return;
                }
                if (this.generateRetraction) {
                    this.resultRow.replace(currentKey, prevAggValue).setHeader((byte)1);
                    out.collect((Object)this.resultRow);
                }
            }
            this.resultRow.replace(currentKey, newAggValue).setHeader((byte)0);
            out.collect((Object)this.resultRow);
        } else {
            if (!firstRow) {
                this.resultRow.replace(currentKey, prevAggValue).setHeader((byte)1);
                out.collect((Object)this.resultRow);
            }
            this.accState.clear();
            this.function.cleanup();
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) throws Exception {
        if (this.stateCleaningEnabled) {
            this.cleanupState(new State[]{this.accState});
            this.function.cleanup();
        }
    }

    public void close() throws Exception {
        if (this.function != null) {
            this.function.close();
        }
    }
}

