/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.LinkedHashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.table.filesystem.PartitionComputer;
import org.apache.flink.table.filesystem.PartitionPathUtils;
import org.apache.flink.table.filesystem.PartitionTempFileManager;
import org.apache.flink.table.filesystem.PartitionWriter;

@Internal
public class SingleDirectoryWriter<T>
implements PartitionWriter<T> {
    private final PartitionComputer<T> computer;
    private final OutputFormat<T> format;

    public SingleDirectoryWriter(PartitionWriter.Context<T> context, PartitionTempFileManager manager, PartitionComputer<T> computer, LinkedHashMap<String, String> staticPartitions) throws Exception {
        this.computer = computer;
        this.format = context.createNewOutputFormat(staticPartitions.size() == 0 ? manager.createPartitionDir(new String[0]) : manager.createPartitionDir(PartitionPathUtils.generatePartitionPath(staticPartitions)));
    }

    @Override
    public void write(T in) throws Exception {
        this.format.writeRecord(this.computer.projectColumnsToWrite(in));
    }

    @Override
    public void close() throws Exception {
        this.format.close();
    }
}

