/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.SqlTimestamp;
import org.apache.flink.table.dataformat.vector.BooleanColumnVector;
import org.apache.flink.table.dataformat.vector.ByteColumnVector;
import org.apache.flink.table.dataformat.vector.BytesColumnVector;
import org.apache.flink.table.dataformat.vector.ColumnVector;
import org.apache.flink.table.dataformat.vector.DecimalColumnVector;
import org.apache.flink.table.dataformat.vector.DoubleColumnVector;
import org.apache.flink.table.dataformat.vector.FloatColumnVector;
import org.apache.flink.table.dataformat.vector.IntColumnVector;
import org.apache.flink.table.dataformat.vector.LongColumnVector;
import org.apache.flink.table.dataformat.vector.ShortColumnVector;
import org.apache.flink.table.dataformat.vector.TimestampColumnVector;

public class VectorizedColumnBatch
implements Serializable {
    private static final long serialVersionUID = 8180323238728166155L;
    public static final int DEFAULT_SIZE = 2048;
    private int numRows;
    public final ColumnVector[] columns;

    public VectorizedColumnBatch(ColumnVector[] vectors) {
        this.columns = vectors;
    }

    public void reset() {
        for (ColumnVector column : this.columns) {
            column.reset();
        }
        this.numRows = 0;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getArity() {
        return this.columns.length;
    }

    public boolean isNullAt(int rowId, int colId) {
        return this.columns[colId].isNullAt(rowId);
    }

    public boolean getBoolean(int rowId, int colId) {
        return ((BooleanColumnVector)this.columns[colId]).getBoolean(rowId);
    }

    public byte getByte(int rowId, int colId) {
        return ((ByteColumnVector)this.columns[colId]).getByte(rowId);
    }

    public short getShort(int rowId, int colId) {
        return ((ShortColumnVector)this.columns[colId]).getShort(rowId);
    }

    public int getInt(int rowId, int colId) {
        return ((IntColumnVector)this.columns[colId]).getInt(rowId);
    }

    public long getLong(int rowId, int colId) {
        return ((LongColumnVector)this.columns[colId]).getLong(rowId);
    }

    public float getFloat(int rowId, int colId) {
        return ((FloatColumnVector)this.columns[colId]).getFloat(rowId);
    }

    public double getDouble(int rowId, int colId) {
        return ((DoubleColumnVector)this.columns[colId]).getDouble(rowId);
    }

    public BytesColumnVector.Bytes getByteArray(int rowId, int colId) {
        return ((BytesColumnVector)this.columns[colId]).getBytes(rowId);
    }

    private byte[] getBytes(int rowId, int colId) {
        BytesColumnVector.Bytes byteArray = this.getByteArray(rowId, colId);
        if (byteArray.len == byteArray.data.length) {
            return byteArray.data;
        }
        return byteArray.getBytes();
    }

    public String getString(int rowId, int colId) {
        BytesColumnVector.Bytes byteArray = this.getByteArray(rowId, colId);
        return new String(byteArray.data, byteArray.offset, byteArray.len, StandardCharsets.UTF_8);
    }

    public Decimal getDecimal(int rowId, int colId, int precision, int scale) {
        return ((DecimalColumnVector)this.columns[colId]).getDecimal(rowId, precision, scale);
    }

    public SqlTimestamp getTimestamp(int rowId, int colId, int precision) {
        return ((TimestampColumnVector)this.columns[colId]).getTimestamp(rowId, precision);
    }
}

