/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.util;

import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.table.dataformat.BinaryRow;
import sun.misc.Unsafe;

public class BinaryRowUtil {
    public static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    public static final int BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    public static final BinaryRow EMPTY_ROW = new BinaryRow(0);

    public static boolean byteArrayEquals(byte[] left, byte[] right, int length) {
        return BinaryRowUtil.byteArrayEquals(left, BYTE_ARRAY_BASE_OFFSET, right, BYTE_ARRAY_BASE_OFFSET, length);
    }

    public static boolean byteArrayEquals(Object left, long leftOffset, Object right, long rightOffset, int length) {
        int i;
        for (i = 0; i <= length - 8; i += 8) {
            if (UNSAFE.getLong(left, leftOffset + (long)i) == UNSAFE.getLong(right, rightOffset + (long)i)) continue;
            return false;
        }
        while (i < length) {
            if (UNSAFE.getByte(left, leftOffset + (long)i) != UNSAFE.getByte(right, rightOffset + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        int size = EMPTY_ROW.getFixedLengthPartSize();
        byte[] bytes = new byte[size];
        EMPTY_ROW.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, size);
    }
}

