/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;

public class TypeCheckUtils {
    public static boolean isNumeric(LogicalType type) {
        return type.getTypeRoot().getFamilies().contains(LogicalTypeFamily.NUMERIC);
    }

    public static boolean isTemporal(LogicalType type) {
        return TypeCheckUtils.isTimePoint(type) || TypeCheckUtils.isTimeInterval(type);
    }

    public static boolean isTimePoint(LogicalType type) {
        return type.getTypeRoot().getFamilies().contains(LogicalTypeFamily.DATETIME);
    }

    public static boolean isRowTime(LogicalType type) {
        return type instanceof TimestampType && ((TimestampType)type).getKind() == TimestampKind.ROWTIME;
    }

    public static boolean isProcTime(LogicalType type) {
        return type instanceof TimestampType && ((TimestampType)type).getKind() == TimestampKind.PROCTIME;
    }

    public static boolean isTimeInterval(LogicalType type) {
        switch (type.getTypeRoot()) {
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCharacterString(LogicalType type) {
        return type.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING);
    }

    public static boolean isBinaryString(LogicalType type) {
        return type.getTypeRoot().getFamilies().contains(LogicalTypeFamily.BINARY_STRING);
    }

    public static boolean isTimestamp(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE;
    }

    public static boolean isTimestampWithLocalZone(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
    }

    public static boolean isBoolean(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.BOOLEAN;
    }

    public static boolean isDecimal(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.DECIMAL;
    }

    public static boolean isInteger(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.INTEGER;
    }

    public static boolean isLong(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.BIGINT;
    }

    public static boolean isArray(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.ARRAY;
    }

    public static boolean isMap(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.MAP;
    }

    public static boolean isAny(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.ANY;
    }

    public static boolean isRow(LogicalType type) {
        return type.getTypeRoot() == LogicalTypeRoot.ROW;
    }

    public static boolean isComparable(LogicalType type) {
        return !TypeCheckUtils.isAny(type) && !TypeCheckUtils.isMap(type) && !TypeCheckUtils.isRow(type) && !TypeCheckUtils.isArray(type);
    }

    public static boolean isMutable(LogicalType type) {
        switch (type.getTypeRoot()) {
            case VARCHAR: 
            case CHAR: 
            case ARRAY: 
            case MULTISET: 
            case MAP: 
            case ROW: 
            case ANY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isReference(LogicalType type) {
        switch (type.getTypeRoot()) {
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: 
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return false;
            }
        }
        return true;
    }
}

