/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Deprecated
public class TypeInfoDataTypeConverter {
    private static final Map<String, TypeInformation<?>> primitiveDataTypeTypeInfoMap = new HashMap();

    private static void addDefaultTypeInfo(Class<?> clazz, TypeInformation<?> typeInformation) {
        Preconditions.checkArgument((boolean)clazz.isPrimitive());
        primitiveDataTypeTypeInfoMap.put(clazz.getName(), typeInformation);
    }

    public static TypeInformation<?> fromDataTypeToTypeInfo(DataType dataType) {
        TypeInformation<?> foundTypeInfo;
        Class clazz = dataType.getConversionClass();
        if (clazz.isPrimitive() && (foundTypeInfo = primitiveDataTypeTypeInfoMap.get(clazz.getName())) != null) {
            return foundTypeInfo;
        }
        LogicalType logicalType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(dataType);
        switch (logicalType.getTypeRoot()) {
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return clazz == Decimal.class ? new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()) : new BigDecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
            }
            case CHAR: 
            case VARCHAR: {
                return clazz == BinaryString.class ? BinaryStringTypeInfo.INSTANCE : BasicTypeInfo.STRING_TYPE_INFO;
            }
            case BINARY: 
            case VARBINARY: {
                return PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            }
            case INTERVAL_YEAR_MONTH: {
                return TimeIntervalTypeInfo.INTERVAL_MONTHS;
            }
            case INTERVAL_DAY_TIME: {
                return TimeIntervalTypeInfo.INTERVAL_MILLIS;
            }
            case ARRAY: {
                if (dataType instanceof CollectionDataType && !PlannerTypeUtils.isPrimitive(((CollectionDataType)dataType).getElementDataType().getLogicalType())) {
                    return ObjectArrayTypeInfo.getInfoFor(TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(((CollectionDataType)dataType).getElementDataType()));
                }
                return TypeConversions.fromDataTypeToLegacyInfo((DataType)dataType);
            }
            case MAP: {
                KeyValueDataType mapType = (KeyValueDataType)dataType;
                return new MapTypeInfo(TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(mapType.getKeyDataType()), TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(mapType.getValueDataType()));
            }
            case MULTISET: {
                return MultisetTypeInfo.getInfoFor(TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(((CollectionDataType)dataType).getElementDataType()));
            }
            case ROW: {
                if (BaseRow.class.isAssignableFrom(dataType.getConversionClass())) {
                    return BaseRowTypeInfo.of((RowType)LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(dataType));
                }
                if (Row.class == dataType.getConversionClass()) {
                    FieldsDataType rowType = (FieldsDataType)dataType;
                    RowType logicalRowType = (RowType)logicalType;
                    return new RowTypeInfo((TypeInformation[])logicalRowType.getFieldNames().stream().map(name -> (DataType)rowType.getFieldDataTypes().get(name)).map(TypeInfoDataTypeConverter::fromDataTypeToTypeInfo).toArray(TypeInformation[]::new), logicalRowType.getFieldNames().toArray(new String[0]));
                }
                return TypeConversions.fromDataTypeToLegacyInfo((DataType)dataType);
            }
        }
        return TypeConversions.fromDataTypeToLegacyInfo((DataType)dataType);
    }

    static {
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Boolean.TYPE, Types.BOOLEAN);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Byte.TYPE, Types.BYTE);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Short.TYPE, Types.SHORT);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Integer.TYPE, Types.INT);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Long.TYPE, Types.LONG);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Float.TYPE, Types.FLOAT);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Double.TYPE, Types.DOUBLE);
    }
}

