/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.wmassigners;

import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.util.Preconditions;

public class MiniBatchedWatermarkAssignerOperator
extends AbstractStreamOperator<BaseRow>
implements OneInputStreamOperator<BaseRow, BaseRow>,
ProcessingTimeCallback {
    private final int rowtimeFieldIndex;
    private final long watermarkDelay;
    private final long tzOffset;
    private final long idleTimeout;
    private long watermarkInterval;
    private transient long currentWatermark;
    private transient long expectedWatermark;
    private transient long lastRecordTime;
    private transient StreamStatusMaintainer streamStatusMaintainer;

    public MiniBatchedWatermarkAssignerOperator(int rowtimeFieldIndex, long watermarkDelay, long tzOffset, long idleTimeout, long watermarkInterval) {
        this.rowtimeFieldIndex = rowtimeFieldIndex;
        this.watermarkDelay = watermarkDelay;
        this.tzOffset = tzOffset;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
        this.watermarkInterval = watermarkInterval;
        this.idleTimeout = idleTimeout;
    }

    public void open() throws Exception {
        super.open();
        Preconditions.checkArgument((this.watermarkInterval > 0L ? 1 : 0) != 0, (Object)"The inferred emit latency should be larger than 0");
        this.currentWatermark = 0L;
        this.expectedWatermark = MiniBatchedWatermarkAssignerOperator.getMiniBatchStart(this.currentWatermark, this.tzOffset, this.watermarkInterval) + this.watermarkInterval - 1L;
        if (this.idleTimeout > 0L) {
            this.lastRecordTime = this.getProcessingTimeService().getCurrentProcessingTime();
            this.streamStatusMaintainer = this.getContainingTask().getStreamStatusMaintainer();
            this.getProcessingTimeService().registerTimer(this.lastRecordTime + this.idleTimeout, (ProcessingTimeCallback)this);
        }
    }

    public void processElement(StreamRecord<BaseRow> element) throws Exception {
        BaseRow row;
        if (this.idleTimeout > 0L) {
            this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
            this.lastRecordTime = this.getProcessingTimeService().getCurrentProcessingTime();
        }
        if ((row = (BaseRow)element.getValue()).isNullAt(this.rowtimeFieldIndex)) {
            throw new RuntimeException("RowTime field should not be null, please convert it to a non-null long value.");
        }
        long wm = row.getLong(this.rowtimeFieldIndex) - this.watermarkDelay;
        this.currentWatermark = Math.max(this.currentWatermark, wm);
        this.output.collect(element);
        if (this.currentWatermark >= this.expectedWatermark) {
            this.output.emitWatermark(new Watermark(this.currentWatermark));
            long start = MiniBatchedWatermarkAssignerOperator.getMiniBatchStart(this.currentWatermark, this.tzOffset, this.watermarkInterval);
            long end = start + this.watermarkInterval - 1L;
            this.expectedWatermark = end > this.currentWatermark ? end : end + this.watermarkInterval;
        }
    }

    public void onProcessingTime(long timestamp) throws Exception {
        long currentTime;
        if (this.idleTimeout > 0L && (currentTime = this.getProcessingTimeService().getCurrentProcessingTime()) - this.lastRecordTime > this.idleTimeout) {
            this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.IDLE);
        }
        long now = this.getProcessingTimeService().getCurrentProcessingTime();
        this.getProcessingTimeService().registerTimer(now + this.watermarkInterval, (ProcessingTimeCallback)this);
    }

    public void processWatermark(Watermark mark) throws Exception {
        if (mark.getTimestamp() == Long.MAX_VALUE && this.currentWatermark != Long.MAX_VALUE) {
            if (this.idleTimeout > 0L) {
                this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
            }
            this.currentWatermark = Long.MAX_VALUE;
            this.output.emitWatermark(mark);
        }
    }

    public void endInput() throws Exception {
        this.processWatermark(Watermark.MAX_WATERMARK);
    }

    public void close() throws Exception {
        this.endInput();
        super.close();
    }

    public static long getMiniBatchStart(long watermark, long tzOffset, long interval) {
        return watermark - (watermark - tzOffset + interval) % interval;
    }
}

