/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.typeutils.AbstractRowSerializer;
import org.apache.flink.table.runtime.util.StreamRecordCollector;

public class RankOperator
extends TableStreamOperator<BaseRow>
implements OneInputStreamOperator<BaseRow, BaseRow> {
    private GeneratedRecordComparator partitionByGenComp;
    private GeneratedRecordComparator orderByGenComp;
    private final long rankStart;
    private final long rankEnd;
    private final boolean outputRankFunColumn;
    private transient RecordComparator partitionByComp;
    private transient RecordComparator orderByComp;
    private transient long rowNum;
    private transient long rank;
    private transient GenericRow rankValueRow;
    private transient JoinedRow joinedRow;
    private transient BaseRow lastInput;
    private transient StreamRecordCollector<BaseRow> collector;
    private transient AbstractRowSerializer<BaseRow> inputSer;

    public RankOperator(GeneratedRecordComparator partitionByGenComp, GeneratedRecordComparator orderByGenComp, long rankStart, long rankEnd, boolean outputRankFunColumn) {
        this.partitionByGenComp = partitionByGenComp;
        this.orderByGenComp = orderByGenComp;
        this.rankStart = rankStart;
        this.rankEnd = rankEnd;
        this.outputRankFunColumn = outputRankFunColumn;
    }

    public void open() throws Exception {
        super.open();
        ClassLoader cl = this.getUserCodeClassloader();
        this.inputSer = (AbstractRowSerializer)this.getOperatorConfig().getTypeSerializerIn1(cl);
        this.partitionByComp = (RecordComparator)this.partitionByGenComp.newInstance(cl);
        this.partitionByGenComp = null;
        this.orderByComp = (RecordComparator)this.orderByGenComp.newInstance(cl);
        this.orderByGenComp = null;
        if (this.outputRankFunColumn) {
            this.joinedRow = new JoinedRow();
            this.rankValueRow = new GenericRow(1);
        }
        this.collector = new StreamRecordCollector(this.output);
    }

    public void processElement(StreamRecord<BaseRow> element) throws Exception {
        BaseRow input = (BaseRow)element.getValue();
        ++this.rowNum;
        if (this.lastInput == null || this.partitionByComp.compare(this.lastInput, input) != 0) {
            this.rank = 1L;
            this.rowNum = 1L;
        } else if (this.orderByComp.compare(this.lastInput, input) != 0) {
            this.rank = this.rowNum;
        }
        this.emitInternal(input);
        this.lastInput = (BaseRow)this.inputSer.copy(input);
    }

    private void emitInternal(BaseRow element) {
        if (this.rank >= this.rankStart && this.rank <= this.rankEnd) {
            if (this.outputRankFunColumn) {
                this.rankValueRow.setLong(0, this.rank);
                this.collector.collect(this.joinedRow.replace(element, this.rankValueRow));
            } else {
                this.collector.collect(element);
            }
        }
    }
}

