/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.sort.BinaryIndexedSortable;
import org.apache.flink.table.runtime.operators.sort.ListMemorySegmentPool;
import org.apache.flink.table.runtime.typeutils.AbstractRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.table.runtime.util.MemorySegmentPool;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;

public final class BinaryInMemorySortBuffer
extends BinaryIndexedSortable {
    private static final int MIN_REQUIRED_BUFFERS = 3;
    private AbstractRowSerializer<BaseRow> inputSerializer;
    private final ArrayList<MemorySegment> recordBufferSegments;
    private final SimpleCollectingOutputView recordCollector;
    private final int totalNumBuffers;
    private long currentDataBufferOffset;
    private long sortIndexBytes;

    public static BinaryInMemorySortBuffer createBuffer(NormalizedKeyComputer normalizedKeyComputer, AbstractRowSerializer<BaseRow> inputSerializer, BinaryRowSerializer serializer, RecordComparator comparator, List<MemorySegment> memory) throws IOException {
        Preconditions.checkArgument((memory.size() >= 3 ? 1 : 0) != 0);
        int totalNumBuffers = memory.size();
        ListMemorySegmentPool pool = new ListMemorySegmentPool(memory);
        ArrayList<MemorySegment> recordBufferSegments = new ArrayList<MemorySegment>(16);
        return new BinaryInMemorySortBuffer(normalizedKeyComputer, inputSerializer, serializer, comparator, recordBufferSegments, new SimpleCollectingOutputView(recordBufferSegments, (MemorySegmentSource)pool, pool.pageSize()), pool, totalNumBuffers);
    }

    private BinaryInMemorySortBuffer(NormalizedKeyComputer normalizedKeyComputer, AbstractRowSerializer<BaseRow> inputSerializer, BinaryRowSerializer serializer, RecordComparator comparator, ArrayList<MemorySegment> recordBufferSegments, SimpleCollectingOutputView recordCollector, MemorySegmentPool pool, int totalNumBuffers) throws IOException {
        super(normalizedKeyComputer, serializer, comparator, recordBufferSegments, pool);
        this.inputSerializer = inputSerializer;
        this.recordBufferSegments = recordBufferSegments;
        this.recordCollector = recordCollector;
        this.totalNumBuffers = totalNumBuffers;
    }

    public void reset() {
        this.numRecords = 0;
        this.currentSortIndexOffset = 0;
        this.currentDataBufferOffset = 0L;
        this.sortIndexBytes = 0L;
        this.returnToSegmentPool();
        this.currentSortIndexSegment = this.nextMemorySegment();
        this.sortIndex.add(this.currentSortIndexSegment);
        this.recordCollector.reset();
    }

    public void returnToSegmentPool() {
        this.memorySegmentPool.returnAll(this.sortIndex);
        this.memorySegmentPool.returnAll(this.recordBufferSegments);
        this.sortIndex.clear();
        this.recordBufferSegments.clear();
    }

    public boolean isEmpty() {
        return this.numRecords == 0;
    }

    public void dispose() {
        this.returnToSegmentPool();
    }

    public long getCapacity() {
        return (long)this.totalNumBuffers * (long)this.memorySegmentPool.pageSize();
    }

    public long getOccupancy() {
        return this.currentDataBufferOffset + this.sortIndexBytes;
    }

    public boolean write(BaseRow record) throws IOException {
        int skip;
        if (!this.checkNextIndexOffset()) {
            return false;
        }
        try {
            skip = this.inputSerializer.serializeToPages(record, (AbstractPagedOutputView)this.recordCollector);
        }
        catch (EOFException e) {
            return false;
        }
        long newOffset = this.recordCollector.getCurrentOffset();
        long currOffset = this.currentDataBufferOffset + (long)skip;
        this.writeIndexAndNormalizedKey(record, currOffset);
        this.currentDataBufferOffset = newOffset;
        return true;
    }

    private BinaryRow getRecordFromBuffer(BinaryRow reuse, long pointer) throws IOException {
        this.recordBuffer.setReadPosition(pointer);
        return this.serializer.mapFromPages(reuse, (AbstractPagedInputView)this.recordBuffer);
    }

    public final MutableObjectIterator<BinaryRow> getIterator() {
        return new MutableObjectIterator<BinaryRow>(){
            private final int size;
            private int current;
            private int currentSegment;
            private int currentOffset;
            private MemorySegment currentIndexSegment;
            {
                this.size = BinaryInMemorySortBuffer.this.size();
                this.current = 0;
                this.currentSegment = 0;
                this.currentOffset = 0;
                this.currentIndexSegment = (MemorySegment)BinaryInMemorySortBuffer.this.sortIndex.get(0);
            }

            public BinaryRow next(BinaryRow target) {
                if (this.current < this.size) {
                    ++this.current;
                    if (this.currentOffset > BinaryInMemorySortBuffer.this.lastIndexEntryOffset) {
                        this.currentOffset = 0;
                        this.currentIndexSegment = (MemorySegment)BinaryInMemorySortBuffer.this.sortIndex.get(++this.currentSegment);
                    }
                    long pointer = this.currentIndexSegment.getLong(this.currentOffset);
                    this.currentOffset += BinaryInMemorySortBuffer.this.indexEntrySize;
                    try {
                        return BinaryInMemorySortBuffer.this.getRecordFromBuffer(target, pointer);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }

            public BinaryRow next() {
                throw new RuntimeException("Not support!");
            }
        };
    }
}

