/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.match;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.util.Collector;

public class RowtimeProcessFunction
extends ProcessFunction<BaseRow, BaseRow>
implements ResultTypeQueryable<BaseRow> {
    private static final long serialVersionUID = 1L;
    private final int rowtimeIdx;
    private transient TypeInformation<BaseRow> returnType;

    public RowtimeProcessFunction(int rowtimeIdx, TypeInformation<BaseRow> returnType) {
        this.rowtimeIdx = rowtimeIdx;
        this.returnType = returnType;
    }

    public void processElement(BaseRow value, ProcessFunction.Context ctx, Collector<BaseRow> out) throws Exception {
        long timestamp = value.getLong(this.rowtimeIdx);
        ((TimestampedCollector)out).setAbsoluteTimestamp(timestamp);
        out.collect((Object)value);
    }

    public TypeInformation<BaseRow> getProducedType() {
        return this.returnType;
    }
}

