/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BinaryStringUtil;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.util.JsonUtils;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.table.utils.ThreadLocalCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFunctionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SqlFunctionUtils.class);
    private static final ThreadLocalCache<String, Pattern> REGEXP_PATTERN_CACHE = new ThreadLocalCache<String, Pattern>(){

        public Pattern getNewInstance(String regex) {
            return Pattern.compile(regex);
        }
    };
    private static final ThreadLocalCache<String, URL> URL_CACHE = new ThreadLocalCache<String, URL>(){

        public URL getNewInstance(String url) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Map<String, String> EMPTY_MAP = new HashMap<String, String>(0);

    public static double exp(Decimal d) {
        return Math.exp(d.doubleValue());
    }

    public static double power(double base, Decimal exponent) {
        return Math.pow(base, exponent.doubleValue());
    }

    public static double power(Decimal base, Decimal exponent) {
        return Math.pow(base.doubleValue(), exponent.doubleValue());
    }

    public static double power(Decimal base, double exponent) {
        return Math.pow(base.doubleValue(), exponent);
    }

    public static double cosh(Decimal x) {
        return Math.cosh(x.doubleValue());
    }

    public static double acos(Decimal a) {
        return Math.acos(a.doubleValue());
    }

    public static double asin(Decimal a) {
        return Math.asin(a.doubleValue());
    }

    public static double atan(Decimal a) {
        return Math.atan(a.doubleValue());
    }

    public static double atan2(Decimal y, Decimal x) {
        return Math.atan2(y.doubleValue(), x.doubleValue());
    }

    public static double sin(Decimal a) {
        return Math.sin(a.doubleValue());
    }

    public static double sinh(Decimal a) {
        return Math.sinh(a.doubleValue());
    }

    public static double cos(Decimal a) {
        return Math.cos(a.doubleValue());
    }

    public static double tan(Decimal a) {
        return Math.tan(a.doubleValue());
    }

    public static double tanh(Decimal a) {
        return Math.tanh(a.doubleValue());
    }

    public static double cot(Decimal a) {
        return 1.0 / Math.tan(a.doubleValue());
    }

    public static double degrees(Decimal angrad) {
        return Math.toDegrees(angrad.doubleValue());
    }

    public static double radians(Decimal angdeg) {
        return Math.toRadians(angdeg.doubleValue());
    }

    public static Decimal abs(Decimal a) {
        return a.abs();
    }

    public static Decimal floor(Decimal a) {
        return a.floor();
    }

    public static Decimal ceil(Decimal a) {
        return a.ceil();
    }

    public static double log(double x) {
        return Math.log(x);
    }

    public static double log(Decimal x) {
        return Math.log(x.doubleValue());
    }

    public static double log(double base, double x) {
        return Math.log(x) / Math.log(base);
    }

    public static double log(double base, Decimal x) {
        return SqlFunctionUtils.log(base, x.doubleValue());
    }

    public static double log(Decimal base, double x) {
        return SqlFunctionUtils.log(base.doubleValue(), x);
    }

    public static double log(Decimal base, Decimal x) {
        return SqlFunctionUtils.log(base.doubleValue(), x.doubleValue());
    }

    public static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    public static double log2(Decimal x) {
        return SqlFunctionUtils.log2(x.doubleValue());
    }

    public static double log10(double x) {
        return Math.log10(x);
    }

    public static double log10(Decimal x) {
        return SqlFunctionUtils.log10(x.doubleValue());
    }

    public static String lpad(String base, int len, String pad) {
        int i;
        if (len < 0 || "".equals(pad)) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        char[] data = new char[len];
        char[] baseChars = base.toCharArray();
        char[] padChars = pad.toCharArray();
        int pos = Math.max(len - base.length(), 0);
        for (i = 0; i < pos; i += pad.length()) {
            for (int j = 0; j < pad.length() && j < pos - i; ++j) {
                data[i + j] = padChars[j];
            }
        }
        for (i = 0; pos + i < len && i < base.length(); ++i) {
            data[pos + i] = baseChars[i];
        }
        return new String(data);
    }

    public static String rpad(String base, int len, String pad) {
        int pos;
        if (len < 0 || "".equals(pad)) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        char[] data = new char[len];
        char[] baseChars = base.toCharArray();
        char[] padChars = pad.toCharArray();
        for (pos = 0; pos < base.length() && pos < len; ++pos) {
            data[pos] = baseChars[pos];
        }
        while (pos < len) {
            for (int i = 0; i < pad.length() && i < len - pos; ++i) {
                data[pos + i] = padChars[i];
            }
            pos += pad.length();
        }
        return new String(data);
    }

    public static String repeat(String str, int repeat) {
        return EncodingUtils.repeat((String)str, (int)repeat);
    }

    public static String replace(String str, String oldStr, String replacement) {
        return str.replace(oldStr, replacement);
    }

    public static String splitIndex(String str, String separator, int index) {
        if (index < 0) {
            return null;
        }
        String[] values = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)separator);
        if (index >= values.length) {
            return null;
        }
        return values[index];
    }

    public static String splitIndex(String str, int character, int index) {
        if (character > 255 || character < 1 || index < 0) {
            return null;
        }
        String[] values = StringUtils.splitPreserveAllTokens((String)str, (char)((char)character));
        if (index >= values.length) {
            return null;
        }
        return values[index];
    }

    public static String regexpReplace(String str, String regex, String replacement) {
        if (str == null || regex == null || replacement == null) {
            return null;
        }
        try {
            return str.replaceAll(regex, Matcher.quoteReplacement(replacement));
        }
        catch (Exception e) {
            LOG.error(String.format("Exception in regexpReplace('%s', '%s', '%s')", str, regex, replacement), (Throwable)e);
            return null;
        }
    }

    public static String regexpExtract(String str, String regex, int extractIndex) {
        if (str == null || regex == null) {
            return null;
        }
        try {
            Matcher m = Pattern.compile(regex).matcher(str);
            if (m.find()) {
                MatchResult mr = m.toMatchResult();
                return mr.group(extractIndex);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Exception in regexpExtract('%s', '%s', '%d')", str, regex, extractIndex), (Throwable)e);
        }
        return null;
    }

    public static String regexpExtract(String str, String regex, long extractIndex) {
        return SqlFunctionUtils.regexpExtract(str, regex, (int)extractIndex);
    }

    public static String regexpExtract(String str, String regex) {
        return SqlFunctionUtils.regexpExtract(str, regex, 0);
    }

    public static BinaryString keyValue(BinaryString str, BinaryString pairSeparator, BinaryString kvSeparator, BinaryString keyName) {
        if (str == null || str.getSizeInBytes() == 0) {
            return null;
        }
        if (pairSeparator != null && pairSeparator.getSizeInBytes() == 1 && kvSeparator != null && kvSeparator.getSizeInBytes() == 1) {
            return BinaryStringUtil.keyValue(str, pairSeparator.byteAt(0), kvSeparator.byteAt(0), keyName);
        }
        return BinaryString.fromString(SqlFunctionUtils.keyValue(BinaryStringUtil.safeToString(str), BinaryStringUtil.safeToString(pairSeparator), BinaryStringUtil.safeToString(kvSeparator), BinaryStringUtil.safeToString(keyName)));
    }

    private static String keyValue(String str, String pairSeparator, String kvSeparator, String keyName) {
        try {
            String[] values;
            if (StringUtils.isEmpty((CharSequence)str)) {
                return null;
            }
            for (String value : values = StringUtils.split((String)str, (String)pairSeparator)) {
                String[] kv;
                if (StringUtils.isEmpty((CharSequence)value) || (kv = StringUtils.split((String)kvSeparator)) == null || kv.length != 2 || !kv[0].equals(keyName)) continue;
                return kv[1];
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Exception when parse key-value", (Throwable)e);
            return null;
        }
    }

    public static String hash(String algorithm, String str) {
        return SqlFunctionUtils.hash(algorithm, str, "");
    }

    public static String hash(String algorithm, String str, String charsetName) {
        try {
            byte[] digest = MessageDigest.getInstance(algorithm).digest(SqlFunctionUtils.strToBytesWithCharset(str, charsetName));
            return EncodingUtils.hex((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unsupported algorithm: " + algorithm, e);
        }
    }

    private static byte[] strToBytesWithCharset(String str, String charsetName) {
        byte[] byteArray = null;
        if (!StringUtils.isEmpty((CharSequence)charsetName)) {
            try {
                byteArray = str.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn("Unsupported encoding: " + charsetName + ", fallback to system charset", (Throwable)e);
                byteArray = null;
            }
        }
        if (byteArray == null) {
            byteArray = str.getBytes();
        }
        return byteArray;
    }

    public static String parseUrl(String urlStr, String partToExtract) {
        URL url;
        try {
            url = (URL)URL_CACHE.get((Object)urlStr);
        }
        catch (Exception e) {
            LOG.error("Parse URL error: " + urlStr, (Throwable)e);
            return null;
        }
        if ("HOST".equals(partToExtract)) {
            return url.getHost();
        }
        if ("PATH".equals(partToExtract)) {
            return url.getPath();
        }
        if ("QUERY".equals(partToExtract)) {
            return url.getQuery();
        }
        if ("REF".equals(partToExtract)) {
            return url.getRef();
        }
        if ("PROTOCOL".equals(partToExtract)) {
            return url.getProtocol();
        }
        if ("FILE".equals(partToExtract)) {
            return url.getFile();
        }
        if ("AUTHORITY".equals(partToExtract)) {
            return url.getAuthority();
        }
        if ("USERINFO".equals(partToExtract)) {
            return url.getUserInfo();
        }
        return null;
    }

    public static String parseUrl(String urlStr, String partToExtract, String key) {
        if (!"QUERY".equals(partToExtract)) {
            return null;
        }
        String query = SqlFunctionUtils.parseUrl(urlStr, partToExtract);
        if (query == null) {
            return null;
        }
        Pattern p = Pattern.compile("(&|^)" + Pattern.quote(key) + "=([^&]*)");
        Matcher m = p.matcher(query);
        if (m.find()) {
            return m.group(2);
        }
        return null;
    }

    public static int divideInt(int a, int b) {
        return a / b;
    }

    public static String subString(String str, long start, long len) {
        int startPos;
        if (len < 0L) {
            LOG.error("len of 'substring(str, start, len)' must be >= 0 and Int type, but len = {0}", (Object)len);
            return null;
        }
        if (len > Integer.MAX_VALUE || start > Integer.MAX_VALUE) {
            LOG.error("len or start of 'substring(str, start, len)' must be Int type, but len = {0}, start = {0}", (Object)len, (Object)start);
            return null;
        }
        int length = (int)len;
        int pos = (int)start;
        if (str.isEmpty()) {
            return "";
        }
        if (pos > 0) {
            startPos = pos - 1;
            if (startPos >= str.length()) {
                return "";
            }
        } else if (pos < 0) {
            startPos = str.length() + pos;
            if (startPos < 0) {
                return "";
            }
        } else {
            startPos = 0;
        }
        int endPos = str.length() - startPos < length ? str.length() : startPos + length;
        return str.substring(startPos, endPos);
    }

    public static String subString(String str, long start) {
        return SqlFunctionUtils.subString(str, start, Integer.MAX_VALUE);
    }

    public static String chr(long chr) {
        if (chr < 0L) {
            return "";
        }
        if ((chr & 0xFFL) == 0L) {
            return String.valueOf('\u0000');
        }
        return String.valueOf((char)(chr & 0xFFL));
    }

    public static String overlay(String s, String r, long start, long length) {
        if (start <= 0L || start > (long)s.length()) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int startPos = (int)start;
        int len = (int)length;
        sb.append(s, 0, startPos - 1);
        sb.append(r);
        if (startPos + len <= s.length() && len > 0) {
            sb.append(s.substring(startPos - 1 + len));
        }
        return sb.toString();
    }

    public static String overlay(String s, String r, long start) {
        return SqlFunctionUtils.overlay(s, r, start, r.length());
    }

    public static int position(BinaryString seek, BinaryString s) {
        return SqlFunctionUtils.position(seek, s, 1);
    }

    public static int position(BinaryString seek, BinaryString s, int from) {
        return s.indexOf(seek, from - 1) + 1;
    }

    public static int instr(BinaryString str, BinaryString subString, int startPosition, int nthAppearance) {
        if (nthAppearance <= 0) {
            throw new IllegalArgumentException("nthAppearance must be positive!");
        }
        if (startPosition == 0) {
            return 0;
        }
        if (startPosition > 0) {
            int startIndex = startPosition;
            int index = 0;
            for (int i = 0; i < nthAppearance; ++i) {
                index = str.indexOf(subString, startIndex - 1) + 1;
                if (index == 0) {
                    return 0;
                }
                startIndex = index + 1;
            }
            return index;
        }
        int pos = SqlFunctionUtils.instr(BinaryStringUtil.reverse(str), BinaryStringUtil.reverse(subString), -startPosition, nthAppearance);
        if (pos == 0) {
            return 0;
        }
        return str.numChars() + 2 - pos - subString.numChars();
    }

    public static String hex(long x) {
        return Long.toHexString(x).toUpperCase();
    }

    public static String hex(String x) {
        return EncodingUtils.hex((byte[])x.getBytes(StandardCharsets.UTF_8)).toUpperCase();
    }

    public static Map<String, String> strToMap(String text) {
        return SqlFunctionUtils.strToMap(text, ",", "=");
    }

    public static Map<String, String> strToMap(String text, String listDelimiter, String keyValueDelimiter) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return EMPTY_MAP;
        }
        String[] keyValuePairs = text.split(listDelimiter);
        HashMap<String, String> ret = new HashMap<String, String>(keyValuePairs.length);
        for (String keyValuePair : keyValuePairs) {
            String[] keyValue = keyValuePair.split(keyValueDelimiter, 2);
            if (keyValue.length < 2) {
                ret.put(keyValuePair, null);
                continue;
            }
            ret.put(keyValue[0], keyValue[1]);
        }
        return ret;
    }

    public static String jsonValue(String jsonString, String pathString) {
        return JsonUtils.getInstance().getJsonObject(jsonString, pathString);
    }

    public static int sround(int b0) {
        return SqlFunctionUtils.sround(b0, 0);
    }

    public static int sround(int b0, int b1) {
        return SqlFunctionUtils.sround(BigDecimal.valueOf(b0), b1).intValue();
    }

    public static long sround(long b0) {
        return SqlFunctionUtils.sround(b0, 0);
    }

    public static long sround(long b0, int b1) {
        return SqlFunctionUtils.sround(BigDecimal.valueOf(b0), b1).longValue();
    }

    public static BigDecimal sround(BigDecimal b0) {
        return SqlFunctionUtils.sround(b0, 0);
    }

    public static BigDecimal sround(BigDecimal b0, int b1) {
        return b0.movePointRight(b1).setScale(0, RoundingMode.HALF_UP).movePointLeft(b1);
    }

    public static double sround(double b0) {
        return SqlFunctionUtils.sround(b0, 0);
    }

    public static double sround(double b0, int b1) {
        return SqlFunctionUtils.sround(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static Decimal sround(Decimal b0) {
        return SqlFunctionUtils.sround(b0, 0);
    }

    public static Decimal sround(Decimal b0, int b1) {
        return Decimal.sround(b0, b1);
    }

    public static Decimal sign(Decimal b0) {
        return Decimal.sign(b0);
    }

    public static boolean isDecimal(Object obj) {
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte || obj instanceof Float || obj instanceof Double || obj instanceof BigDecimal || obj instanceof BigInteger) {
            return true;
        }
        if (obj instanceof String || obj instanceof Character) {
            String s = obj.toString();
            if (s.isEmpty()) {
                return false;
            }
            return SqlFunctionUtils.isInteger(s) || SqlFunctionUtils.isLong(s) || SqlFunctionUtils.isDouble(s);
        }
        return false;
    }

    private static boolean isInteger(String s) {
        boolean flag = true;
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            flag = false;
        }
        return flag;
    }

    private static boolean isLong(String s) {
        boolean flag = true;
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            flag = false;
        }
        return flag;
    }

    private static boolean isDouble(String s) {
        boolean flag = true;
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            flag = false;
        }
        return flag;
    }

    public static boolean isDigit(Object obj) {
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return true;
        }
        if (obj instanceof String) {
            String s = obj.toString();
            if (s.isEmpty()) {
                return false;
            }
            return StringUtils.isNumeric((CharSequence)s);
        }
        return false;
    }

    public static boolean isAlpha(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof String)) {
            return false;
        }
        String s = obj.toString();
        if ("".equals(s)) {
            return false;
        }
        return StringUtils.isAlpha((CharSequence)s);
    }

    public static Integer hashCode(String str) {
        if (str == null) {
            return Integer.MIN_VALUE;
        }
        return Math.abs(str.hashCode());
    }

    public static Boolean regExp(String s, String regex) {
        if (regex.length() == 0) {
            return false;
        }
        try {
            return ((Pattern)REGEXP_PATTERN_CACHE.get((Object)regex)).matcher(s).find(0);
        }
        catch (Exception e) {
            LOG.error("Exception when compile and match regex:" + regex + " on: " + s, (Throwable)e);
            return false;
        }
    }

    public static Byte bitAnd(Byte a, Byte b) {
        if (a == null || b == null) {
            return (byte)0;
        }
        return (byte)(a & b);
    }

    public static Short bitAnd(Short a, Short b) {
        if (a == null || b == null) {
            return (short)0;
        }
        return (short)(a & b);
    }

    public static Integer bitAnd(Integer a, Integer b) {
        if (a == null || b == null) {
            return 0;
        }
        return a & b;
    }

    public static Long bitAnd(Long a, Long b) {
        if (a == null || b == null) {
            return 0L;
        }
        return a & b;
    }

    public static Byte bitNot(Byte a) {
        if (a == null) {
            a = 0;
        }
        return ~a.byteValue();
    }

    public static Short bitNot(Short a) {
        if (a == null) {
            a = 0;
        }
        return ~a.shortValue();
    }

    public static Integer bitNot(Integer a) {
        if (a == null) {
            a = 0;
        }
        return ~a.intValue();
    }

    public static Long bitNot(Long a) {
        if (a == null) {
            a = 0L;
        }
        return a ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static Byte bitOr(Byte a, Byte b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return (byte)(a | b);
    }

    public static Short bitOr(Short a, Short b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return (short)(a | b);
    }

    public static Integer bitOr(Integer a, Integer b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return a | b;
    }

    public static Long bitOr(Long a, Long b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0L;
            }
            if (b == null) {
                b = 0L;
            }
        }
        return a | b;
    }

    public static Byte bitXor(Byte a, Byte b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return (byte)(a ^ b);
    }

    public static Short bitXor(Short a, Short b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return (short)(a ^ b);
    }

    public static Integer bitXor(Integer a, Integer b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0;
            }
            if (b == null) {
                b = 0;
            }
        }
        return a ^ b;
    }

    public static Long bitXor(Long a, Long b) {
        if (a == null || b == null) {
            if (a == null) {
                a = 0L;
            }
            if (b == null) {
                b = 0L;
            }
        }
        return a ^ b;
    }

    public static String toBase64(BinaryString bs) {
        return SqlFunctionUtils.toBase64(bs.getBytes());
    }

    public static String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] fromBase64(BinaryString bs) {
        return Base64.getDecoder().decode(bs.getBytes());
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid(byte[] b) {
        return UUID.nameUUIDFromBytes(b).toString();
    }

    public static Decimal struncate(Decimal b0) {
        return SqlFunctionUtils.struncate(b0, 0);
    }

    public static Decimal struncate(Decimal b0, int b1) {
        if (b1 >= b0.getScale()) {
            return b0;
        }
        BigDecimal b2 = b0.toBigDecimal().movePointRight(b1).setScale(0, RoundingMode.DOWN).movePointLeft(b1);
        int p = b0.getPrecision();
        int s = b0.getScale();
        if (b1 < 0) {
            return Decimal.fromBigDecimal(b2, Math.min(38, 1 + p - s), 0);
        }
        return Decimal.fromBigDecimal(b2, 1 + p - s + b1, b1);
    }

    public static float struncate(float b0) {
        return SqlFunctionUtils.struncate(b0, 0);
    }

    public static float struncate(float b0, int b1) {
        return (float)SqlFunctionUtils.struncate(Decimal.castFrom(b0, 38, 18), b1).doubleValue();
    }
}

