/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.compression;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.flink.table.runtime.compression.BlockCompressor;
import org.apache.flink.table.runtime.compression.InsufficientBufferException;
import org.apache.flink.table.shaded.net.jpountz.lz4.LZ4Compressor;
import org.apache.flink.table.shaded.net.jpountz.lz4.LZ4Exception;
import org.apache.flink.table.shaded.net.jpountz.lz4.LZ4Factory;

public class Lz4BlockCompressor
implements BlockCompressor {
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return 8 + this.compressor.maxCompressedLength(srcSize);
    }

    @Override
    public int compress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws InsufficientBufferException {
        try {
            int prevSrcOff = src.position() + srcOff;
            int prevDstOff = dst.position() + dstOff;
            int maxCompressedSize = this.compressor.maxCompressedLength(srcLen);
            int compressedLength = this.compressor.compress(src, prevSrcOff, srcLen, dst, prevDstOff + 8, maxCompressedSize);
            src.position(prevSrcOff + srcLen);
            dst.position(prevDstOff);
            dst.putInt(compressedLength);
            dst.putInt(srcLen);
            dst.position(prevDstOff + compressedLength + 8);
            return 8 + compressedLength;
        }
        catch (ArrayIndexOutOfBoundsException | BufferOverflowException | LZ4Exception e) {
            throw new InsufficientBufferException(e);
        }
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws InsufficientBufferException {
        try {
            int compressedLength = this.compressor.compress(src, srcOff, srcLen, dst, dstOff + 8);
            Lz4BlockCompressor.writeIntLE(compressedLength, dst, dstOff);
            Lz4BlockCompressor.writeIntLE(srcLen, dst, dstOff + 4);
            return 8 + compressedLength;
        }
        catch (ArrayIndexOutOfBoundsException | BufferOverflowException | LZ4Exception e) {
            throw new InsufficientBufferException(e);
        }
    }

    private static void writeIntLE(int i, byte[] buf, int offset) {
        buf[offset++] = (byte)i;
        buf[offset++] = (byte)(i >>> 8);
        buf[offset++] = (byte)(i >>> 16);
        buf[offset] = (byte)(i >>> 24);
    }
}

