/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.compression;

import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.table.runtime.compression.BlockCompressor;
import org.apache.flink.table.runtime.compression.BlockDecompressor;
import org.apache.flink.table.runtime.compression.Lz4BlockCompressionFactory;
import org.apache.flink.util.Preconditions;

public interface BlockCompressionFactory {
    public BlockCompressor getCompressor();

    public BlockDecompressor getDecompressor();

    public static BlockCompressionFactory createBlockCompressionFactory(String compressionFactoryName) {
        BlockCompressionFactory blockCompressionFactory;
        block11: {
            Object factoryObj;
            block10: {
                CompressionFactoryName compressionName;
                Preconditions.checkNotNull((Object)compressionFactoryName);
                try {
                    compressionName = CompressionFactoryName.valueOf(compressionFactoryName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    compressionName = null;
                }
                blockCompressionFactory = null;
                if (compressionName == null) break block10;
                switch (compressionName) {
                    case LZ4: {
                        blockCompressionFactory = new Lz4BlockCompressionFactory();
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Unknown CompressionMethod " + (Object)((Object)compressionName));
                    }
                }
            }
            try {
                factoryObj = Class.forName(compressionFactoryName).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalConfigurationException("Cannot load class " + compressionFactoryName, (Throwable)e);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Cannot create object for class " + compressionFactoryName, (Throwable)e);
            }
            if (factoryObj instanceof BlockCompressionFactory) {
                blockCompressionFactory = (BlockCompressionFactory)factoryObj;
            } else {
                throw new IllegalArgumentException("CompressionFactoryName should inherit from interface BlockCompressionFactory, or use the default compression codec.");
            }
        }
        Preconditions.checkNotNull((Object)blockCompressionFactory);
        return blockCompressionFactory;
    }

    public static enum CompressionFactoryName {
        LZ4;

    }
}

