/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryFormat;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.util.Preconditions;

public final class NestedRow
extends BinaryFormat
implements BaseRow {
    private final int arity;
    private final int nullBitsSizeInBytes;

    public NestedRow(int arity) {
        Preconditions.checkArgument((arity >= 0 ? 1 : 0) != 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRow.calculateBitSetWidthInBytes(arity);
    }

    static NestedRow readNestedRowFieldFromSegments(MemorySegment[] segments, int numFields, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        NestedRow row = new NestedRow(numFields);
        row.pointTo(segments, offset + baseOffset, size);
        return row;
    }

    private int getFieldOffset(int pos) {
        return this.offset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    @Override
    public int getArity() {
        return this.arity;
    }

    @Override
    public byte getHeader() {
        return SegmentsUtil.getByte(this.segments, this.offset);
    }

    @Override
    public void setHeader(byte header) {
        SegmentsUtil.setByte(this.segments, this.offset, header);
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        SegmentsUtil.bitUnSet(this.segments, this.offset, i + 8);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        SegmentsUtil.bitSet(this.segments, this.offset, i + 8);
        SegmentsUtil.setLong(this.segments, this.getFieldOffset(i), 0L);
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setInt(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setLong(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setDouble(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            this.setLong(pos, value.toUnscaledLong());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(SegmentsUtil.getLong(this.segments, fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            SegmentsUtil.setLong(this.segments, this.offset + cursor, 0L);
            SegmentsUtil.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                SegmentsUtil.setLong(this.segments, fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                SegmentsUtil.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setBoolean(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setShort(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setByte(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        SegmentsUtil.setFloat(this.segments, this.getFieldOffset(pos), value);
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.bitGet(this.segments, this.offset, pos + 8);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getBoolean(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getByte(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getShort(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getInt(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getLong(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getFloat(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return SegmentsUtil.getDouble(this.segments, this.getFieldOffset(pos));
    }

    @Override
    public BinaryString getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = SegmentsUtil.getLong(this.segments, fieldOffset);
        return BinaryString.readBinaryStringFieldFromSegments(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            return Decimal.fromUnscaledLong(precision, scale, SegmentsUtil.getLong(this.segments, this.getFieldOffset(pos)));
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = SegmentsUtil.getLong(this.segments, fieldOffset);
        return Decimal.readDecimalFieldFromSegments(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public <T> BinaryGeneric<T> getGeneric(int pos) {
        this.assertIndexIsValid(pos);
        return BinaryGeneric.readBinaryGenericFieldFromSegments(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = SegmentsUtil.getLong(this.segments, fieldOffset);
        return NestedRow.readBinaryFieldFromSegments(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public BaseRow getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        return NestedRow.readNestedRowFieldFromSegments(this.segments, numFields, this.offset, this.getLong(pos));
    }

    @Override
    public BaseArray getArray(int pos) {
        this.assertIndexIsValid(pos);
        return BinaryArray.readBinaryArrayFieldFromSegments(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public BaseMap getMap(int pos) {
        this.assertIndexIsValid(pos);
        return BinaryMap.readBinaryMapFieldFromSegments(this.segments, this.offset, this.getLong(pos));
    }

    public NestedRow copy() {
        return this.copy(new NestedRow(this.arity));
    }

    public NestedRow copy(BaseRow reuse) {
        return this.copyInternal((NestedRow)reuse);
    }

    private NestedRow copyInternal(NestedRow reuse) {
        byte[] bytes = SegmentsUtil.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public int hashCode() {
        return SegmentsUtil.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }
}

